/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#ifndef msdos
#include <signal.h>
#ifndef VMS
#include <sys/types.h>
#include <unistd.h>
#endif
#include "sig.h"
#include "file.h"
#include "sysdep.h"
#include "slang.h"
#include "misc.h"
#include "screen.h"

int last_signal_code;
int signal_in_progress = 0;

#ifndef VMS
void resize_display()
{
   int r, c;
   get_term_dimensions(&c, &r);
   change_screen_size(c, r);
   signal (SIGWINCH, resize_display);
}
#endif

void my_signal(int sig)
{
    last_signal_code = sig;
    /* set signal to point to default */
    signal(sig, SIG_DFL);

    if (signal_in_progress)
      kill(getpid(), last_signal_code);

    signal_in_progress = 1;

    auto_save_all();
    reset_display();
    reset_tty();
    kill (getpid (), last_signal_code);
}

/* a control-G puts us here */
void my_interrupt(int sig)
{
   KeyBoard_Quit = 1;
   Lang_Error = -1;
   signal (SIGINT, my_interrupt);
}

void init_signals()
{
#ifndef VMS
   (void) signal(SIGWINCH,resize_display);
#endif
   signal (SIGINT, my_interrupt);
   signal (SIGHUP, my_signal);
   signal (SIGQUIT, my_signal);
   signal (SIGILL, my_signal);
   signal (SIGTRAP, my_signal);
   signal (SIGIOT, my_signal);
   signal (SIGFPE, my_signal);
#ifdef SIGBUS
   signal (SIGBUS, my_signal);
#endif
   signal (SIGSEGV, my_signal);
#ifdef SIGSYS
    signal (SIGSYS, my_signal);
#endif
    signal (SIGTERM, my_signal);
}
#endif
