;; make a doc file for jed intrinsics
(
  [filein fileout] =fileout =filein
  [cbuf dbuf fbuf] whatbuf =cbuf
  [sstr] "add_intrinsic(" =sstr
  [sname cname type nparms]
  [comma commas] "," =comma ",\t " =commas
  [err_msg] "Corrupt file?" =err_msg
  
  filein find_file { "File not found."  error } !if whatbuf =fbuf
  fileout find_file pop whatbuf =dbuf
  erase_buffer
  
  fbuf setbuf bob
  {sstr fsearch}{
     bol skip_white sstr looking_at {continue} !if
     15 right pop  ;; at name
     
     push_mark "\"" ffind { err_msg  error } !if bufsubstr =sname
     
     ")" ffind { err_msg error } !if
     ")\t " skip_chars  push_mark comma ffind {err_msg error} !if 
     bufsubstr =cname
     
     commas skip_chars  push_mark comma ffind {err_msg error} !if
     bufsubstr =type
     
     commas skip_chars  push_mark "0-9" skip_chars  bufsubstr =nparms
     
     dbuf setbuf
     "@" insert sname insert 30 goto_column "C function: " insert cname insert
     "\n;; takes " insert nparms insert " parameter(s) returning " insert 
     type insert "\n" insert
     fbuf setbuf
     1 down pop bol skip_white 
     "/*;;" looking_at {
        bol push_mark
	"*/" fsearch {err_msg error} !if
	dbuf copy_region
	dbuf setbuf "/*" bsearch pop bol trim del del
	{1 down} {bol trim} while
	eolp {eol "\n" insert} !if
	fbuf setbuf
     } if
  } while
) mkdoc

"ledit.c" "jed_funs.hlp" mkdoc
"jed_funs.hlp" setbuf 
"jed_funs.hlp" write_buffer pop
exit_jed
