/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include "buffer.h"
#include "screen.h"
#include "window.h"
#include "vterm.h"

void vscroll_down(int r1, int r2, int num)
{
    char *old;
    int r;

    r1--; r2--;
    while(num--)
      {
          old = Screen[r2].old;
          for (r = r2; r > r1; r--)
            {
                Screen[r].line = Screen[r-1].line;
                Screen[r].n = Screen[r-1].n;
                Screen[r].flags = Screen[r-1].flags;
                Screen[r].old = Screen[r-1].old;
            }

          Screen[r1].line = NULL;
          Screen[r1].n = 0;
          Screen[r1].flags = 0;
          Screen[r1].old = old;
          blank_line(r1);
      }
}

void vscroll_up(int r1, int r2, int num)
{
    char *old;
    int r;

    r1--; r2--;
    while(num--)
      {
          old = Screen[r1].old;
          for (r = r1; r < r2; r++)
            {
                Screen[r].line = Screen[r+1].line;
                Screen[r].n = Screen[r+1].n;
                Screen[r].flags = Screen[r+1].flags;
                Screen[r].old = Screen[r+1].old;
            }

          Screen[r2].line = NULL;
          Screen[r2].n = 0;
          Screen[r2].flags = 0;
          Screen[r2].old = old;
          blank_line(r2);
      }
}

void vins(char ch)
{
    int r;
    char *pins, *p;

    r = Screen_Row - 1;
    if (ch > ' ') Screen[r].n += 1;
    pins = Screen[r].old + Screen_Col - 1;
    p = Screen[r].old + Window->width - 1;
    while(p > pins)
      {
          *p = *(p - 1);
          p--;
      }
    *p = ch;
}

void vdel()
{
    int r;
    char *pmax, *p;

    r = Screen_Row - 1;
    p = Screen[r].old + Screen_Col - 1;
    pmax = Screen[r].old + Window->width - 1;
    while(p < pmax)
      {
          *p = *(p + 1);
          p++;
      }
    *p = ' ';
}

void vdel_eol()
{
    int r;
    char *pmax, *p;

    r = Screen_Row - 1;
    p = Screen[r].old + Screen_Col - 1;
    pmax = Screen[r].old + Window->width - 1;
    while(p < pmax)
      {
          *p = ' ';
          p++;
      }
    *p = ' ';
}

