/*  mls.c        -- do an 'ls -lR' of a Minix file system */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MLS.C_V 1.5 91/04/05 15:51:35 SWH Exp $ */

#include    <stdio.h>
#include    <ctype.h>
#include    <stdlib.h>
#include    <string.h>
#include    "mfs.h"
#include    "dev.h"

DEVINIT
READ_BLOCK
SHOW_DIR

BOOL    Nonly ;


/*==================================================================*/
main (argc, argv)
int     argc ;
char    *argv[] ;
{
    int     drive ;
    char    drid = 'A' ;
    char    *dp = DRIVES ;

    byte    buf[BLOCK_SIZE] ;
    int     blkno ;
    struct super_block  sblk ;

    struct inode    *iarea, *ip ;
    int     inode_blkno ;
    int     inode_blkct ;
    int     inode_count ;

    struct directory    *darea ;
    struct devdata      *ddata ;

    int     i, j, k, n ;

    printf ("**** Displays directories in a Minix file system ****\n") ;
    printf ("\n") ;

/*  Does he want help?
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == '?'))
    {
printf ("Copyright 1988,1991 Steven W. Harrold - All rights reserved\n") ;
        printf ("Version %s\n", VERSION) ;
        printf ("Usage:   %s  [-l] [drid]\n", argv[0]) ;
        printf ("'-l' causes long form of directory details to be listed\n") ;
        printf ("'drid' is a letter from the set [a-z], default: 'a'\n") ;
        exit (0) ;
    }

/*  Get the option flag
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == 'l'))
    {
        Nonly = FALSE ;
        argc-- ;
        argv++ ;
    }
    else
        Nonly = TRUE ;

/*  Fetch the drive identifier
 */
    if (argc >= 2)
    {
        drid = toupper(argv[1][0]) ;
        if ((drid < 'A') || (drid > 'Z'))
            drid = 'A' ;
    }
    drive = strchr (dp, drid) - dp ;
    ddata = devinit (drive, 0) ;
    if (!ddata)
    {
        printf ("Cannot initialize device 0x%02X, Dstatus=%d\n",
                drive, Dstatus) ;
        exit (2) ;
    }

/*  The super block
 */
    blkno = SUPER_BLOCK ;
    read_block (buf, blkno, ddata) ;
    memcpy (&sblk, buf, sizeof(sblk)) ;

    if ((sblk.s_magic != SUPER_MAGIC)   ||
        (sblk.s_ninodes < 1)            ||
        (sblk.s_nzones < 1)             ||
        (sblk.s_imap_blocks < 1)        ||
        (sblk.s_zmap_blocks < 1)        )
    {
        printf ("+++++++++++++++++++++++++++++++++++++++++++++++\n") ;
        printf ("++++++++ THIS IS NOT A PROPER MINIX DISK ++++++\n") ;
        printf ("+++++++++++++++++++++++++++++++++++++++++++++++\n") ;
        exit (2) ;
    }

/*  The i-node blocks
 */
    inode_blkno = SUPER_BLOCK + sblk.s_imap_blocks +
                                sblk.s_zmap_blocks + 1 ;
    inode_blkct = sblk.s_ninodes * sizeof(struct inode) + (BLOCK_SIZE-1) ;
    inode_blkct /= BLOCK_SIZE ;
    inode_count = inode_blkct * sizeof(struct inode) ;

    iarea = calloc (inode_count+1, sizeof(struct inode)) ;
    if (!iarea)
        exit(3) ;

    ip = iarea + 1 ;
    blkno = inode_blkno ;
    j = BLOCK_SIZE / sizeof(struct inode) ;

    for (i=1; i<=inode_blkct; i++, ip += j, blkno++)
        read_block (ip, blkno, ddata) ;


/*  Finally, the directories
 */
    ip = iarea + ROOT_INODE ;           /* start with root */
    show_dir(ddata, iarea, ip, "/") ;   /* recursively print */

/*  Clean up
 */
    free (iarea) ;

} /* main() */


/*---eof---*/
