PAGE	58,132
TITLE	FDATE	9-3-85	[5-22-92]
;v1.1	Toad Hall Disassembly and Tweak, 22 May 92

; - Minor tightening
; - No functional changes.

LF	EQU	0AH
CR	EQU	0DH
;
CSEG	SEGMENT
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	ORG	100H

FDate2	PROC	NEAR
	JMP	Start_1E3		;skip over data

dateflag103	db	0		;non-0 if we have a date to set
timeflag105	db	0		;non-0 if we have a time to set
date107		dw	0		;processed DOS-type date
time109		dw	0		;processed DOS-type time
filedate10B	dw	0		;original file date
filetime10D	dw	0		;original file time
whour10F	dw	0
wminute111	dw	0
wseconds113	dw	0
wday115		dw	0
wmonth117	dw	0
wyear119	dw	0
bchar11B	DB	0		;save date or time separator char
argc11C		db	0		;temp arg counter (was word)	v1.1
arg11E		dw	0		;argv[] pointer

usage$	DB	'Usage is: FDATE <filename> [mm/dd/yy] [hh:mm:ss]'
	DB	CR,LF,'$'
notfound	DB	'Could not find file'
	DB	CR,LF,'$'
baddate	DB	'Incorrect date, format is mm/dd/yy or mm-dd-yy'
	DB	CR,LF,'$'
badtime	DB	'Incorrect time, format is hh:mm:ss'
	DB	CR,LF,'$'
filerr	DB	'Internal error during file access'
	db	CR,LF,'$'


Start_1E3:
	CALL	GetParms_3F0
	CMP	argc440,0		;any args at all?
	JZ	Usage_241		;nope, Usage, quit
	CMP	argc440,3		;more than 3?
	JA	Usage_241		;yep, Usage, quit
	CMP	argc440,1		;just one?  (should be filename)
	JNZ	Got_DateParms_24D	;nope, 2, we have date/time parms too

	MOV	AH,2AH			;Get date
	INT	21H			;CX=year 1980..2099
	SUB	CX,076CH		;year minus 1980
	MOV	wyear119,CX		;save it
;v1.1	MOV	CL,DH			;month (1..12)
;	MOV	CH,0			;clear msb
;	MOV	wmonth117,CX		;save month
;	MOV	CL,DL			;day of month
;	MOV	wday115,CX		;save day of month
	mov	al,dh			;month (1..12)
	xor	ah,ah			;clear msb
	mov	wmonth117,ax		;save month
	mov	al,dl			;day of month
	mov	wday115,ax		;save day of month

	MOV	AH,2CH			;Get system time
	INT	21H
;v1.1	MOV	AX,0			;clear msb
	xor	ax,ax			;clear msb			v1.1
	MOV	AL,CH			;hour
	MOV	whour10F,AX
	MOV	AL,CL			;minute
	MOV	wminute111,AX
	MOV	AL,DH			;seconds
	MOV	wseconds113,AX
	CMP	argc440,1
	JNZ	Got_DateParms_24D	;we have date/time parms too

	MOV	dateflag103,1		;flag we got date
	MOV	timeflag105,1		;flag we got time
	JMP	Set_FileDTG_343		;go set this file's DTG

Usage_241:
	MOV	DX,OFFSET usage$
	MOV	AH,9
	INT	21H
	MOV	AL,1
	JMP	Term_3D3


;We have more than just a filename.
;Process other parms for possible date/time.

Got_DateParms_24D:
	MOV	al,argc440		;cmdline argc			v1.1
	MOV	argc11C,al		;save total arg count		v1.1
	MOV	arg11E,0		;start with arg 0

Lup259:	ADD	arg11E,2		;bump argc (*2 for words)
	DEC	argc11C			;decr art count
	JNZ	Skp267			;not done yet
	 JMP	Set_FileDTG_343		;go set this file's DTG

Skp267:	MOV	BX,arg11E		;argc
	MOV	SI,[BX+argv442]		;argv[x]
	CALL	AtoB_550		;convert to number if appropriate
	CMP	AL,'/'			;this date separator?
	JZ	Do_Date_289		;yep, doing date
	CMP	AL,'-'			;this date separator?
	JZ	Do_Date_289		;yep, doing date
	CMP	AL,':'			;time separator?
	JZ	Do_Time_2E9		;yep, doing time
	JMP	SHORT	Usage_241	;error, Usage, die

;v1.1	Moved this down closer to Term_3D3 and error msgs
;MsgTerm_280:
;	MOV	AH,9			;display msg in DX
;	INT	21H
;	MOV	AL,2			;ERRORLEVEL 2
;	JMP	Term_3D3		;terminate

;Separator is '/' or '-' : We're doing date
Do_Date_289:
	CMP	dateflag103,0		;did we ever get date?
	JZ	Skp292			;nope, not yet, ok
	 JMP	SHORT	Usage_241	;got two dates: bad, die

Skp292:	MOV	dateflag103,1		;flag we got date
	CMP	CX,0
	JBE	BadDate_2E4
	CMP	CX,0CH			;months 1..12
	JA	BadDate_2E4		;bad month

	MOV	wmonth117,CX		;save as month
	MOV	bchar11B,AL		;save '/' or '-'
	INC	SI
	CALL	AtoB_550		;should be getting day of month
;v1.1	CMP	AL,0
	or	al,al	;0		;parm separator?
	JZ	Skp2B7			;yep, check day
	 CMP	AL,bchar11B		;we hit a date separator?
	 JNZ	BadDate_2E4		;nope, bad, terminate

Skp2B7:	CMP	CX,0			;any numeric value?
	JBE	BadDate_2E4		;nope, bad
	CMP	CX,1FH			;day is only 1..31
	JA	BadDate_2E4		;bad
	MOV	wday115,CX		;save day
;v1.1	CMP	AL,0
	or	al,al	;0		;this parm's terminator?	v1.1
	JNZ	Skp2CB			;nope, real char
	 JMP	SHORT	Lup259		;next parm

Skp2CB:	INC	SI			;next char
	CALL	AtoB_550		;parse year
;v1.1	CMP	AL,0
	or	al,al	;0		;hit parm separator?
	JNZ	BadDate_2E4		;nope, date was bad

	CMP	CX,50H			;min date 80 as in 1980
	JB	BadDate_2E4		;bad year
	CMP	CX,63H			;only up to 1999?
	JA	BadDate_2E4		;bad year
	 MOV	wyear119,CX		;save as year
	 JMP	Lup259			;next parm

BadDate_2E4:
	MOV	DX,OFFSET baddate	;'Incorrect date'
	JMP	MsgTerm_280		;display, die

;Hit ':' in cmdline.  Now working time.
Do_Time_2E9:
	CMP	timeflag105,0		;did we get time yet?
	JZ	Skp2F3			;not yet, ok
	 JMP	Usage_241		;bad, msg, terminate

Skp2F3:	MOV	timeflag105,1		;flag we got time
	CMP	CX,18H			;<= 24?
	JA	BadTime_33D		;>24, bad time, die
	MOV	whour10F,CX		;save hours
	MOV	bchar11B,AL		;working this ':' separator
	INC	SI			;next char
	CALL	AtoB_550		;get minutes
;v1.1	CMP	AL,0
	or	al,al			;parm separator?		v1.1
	JZ	Skp313			;yep
	CMP	AL,bchar11B		;still ':' separator?
	JNZ	BadTime_33D		;nope, bad, die

Skp313:	CMP	CX,3BH			;max 59 minutes?
	JA	BadTime_33D		;bad, die
	MOV	wminute111,CX		;save minutes
;v1.1	CMP	AL,0
	or	al,al			;parm separator yet?
	JNZ	GetSeconds_329		;not yet
	 MOV	wseconds113,0		;yep, zero seconds out
	 JMP	Lup259			;next parm

GetSeconds_329:
	INC	SI			;bump past separator
	CALL	AtoB_550		;get seconds
;v1.1	CMP	AL,0
	or	al,al	;0		;separator yet?
	JNZ	BadTime_33D		;nope, time is bad, die
	CMP	CX,3BH			;max 59 seconds
	JA	BadTime_33D		;>59, bad, die

	MOV	wseconds113,CX		;save as seconds
	JMP	Lup259			;next parm

BadTime_33D:
	MOV	DX,OFFSET badtime	;'Incorrect time'
	JMP	MsgTerm_280		;display, die


;We have time/date.  Set the file date/time to it.

Set_FileDTG_343:
	MOV	AX,wyear119
	SUB	AX,50H		;-80
	MOV	CX,4
	SHL	AX,CL		;*16
	OR	AX,wmonth117
	MOV	CX,5		;*32
	SHL	AX,CL
	OR	AX,wday115
	MOV	date107,AX	;here's the processed DOS date word

	MOV	AX,whour10F	;build a DOS-format time word
	MOV	CX,6
	SHL	AX,CL
	OR	AX,wminute111
	MOV	CX,5
	SHL	AX,CL
	MOV	BX,wseconds113
	SHR	BX,1
	OR	AX,BX
	MOV	time109,AX		;here's the processed date/time value

	MOV	DX,argv442		;pointer to filename
;v1.1	MOV	AL,2			;read-only?
;	MOV	AH,3DH			;open file
	mov	ax,3D02H		;open file, read-only		v1.1
	INT	21H
	JB	NotFound_3D8		;open failed

	MOV	BX,AX			;file handle into BX
	MOV	al,dateflag103		;get date flag			v1.1
	AND	al,timeflag105		;mask with time flag		v1.1
	JNZ	Skp3A1			;we already have cmdline date/time
;v1.1	MOV	AH,57H			;get file date/time
;v1.1	MOV	AL,0
	mov	ax,5700H		;get file date/time		v1.1
	INT	21H
	JB	File_Error_3DE		;failed

	MOV	filedate10B,DX		;save date
	MOV	filetime10D,CX		;save time

Skp3A1:	CMP	timeflag105,0		;ever get time?
	JZ	Skp3AE			;nope
	 MOV	AX,time109		;processed time
	 MOV	filetime10D,AX
Skp3AE:	CMP	dateflag103,0
	JZ	Skp3BB
	 MOV	AX,date107		;processed date
	 MOV	filedate10B,AX
Skp3BB:
;v1.1	MOV	AL,1
;	MOV	AH,57H
	mov	ax,5701H		;set file time			v1.1
	MOV	DX,filedate10B		;to this date
	MOV	CX,filetime10D		; and time
	INT	21H
	JB	File_Error_3DE		;failed

	MOV	AH,3EH			;close file
	INT	21H
	JB	File_Error_3DE		;failed

;v1.1	MOV	AL,0
	xor	ax,ax			;ERRORLEVEL 0			v1.1

Term_3D3:
	MOV	AH,4CH			;terminate
	INT	21H
;dumb	RET_NEAR

NotFound_3D8:
	MOV	DX,OFFSET notfound	;'Could not find file'
	JMP	short MsgTerm_280

File_Error_3DE:
	MOV	DX,OFFSET filerr	;'Internal error during file access'
;	JMP	MsgTerm_280
MsgTerm_280:
	MOV	AH,9			;display msg in DX
	INT	21H
	MOV	AL,2			;ERRORLEVEL 2
	JMP	Term_3D3		;terminate

;dumb	DB	0CH DUP(0)
FDate2	ENDP


GetParms_3F0	PROC	NEAR
;dumb	PUSH	DS
;dumb	PUSH	ES
;dumb	CLD
;dumb	MOV	AX,CS
;dumb	MOV	DS,AX
;dumb	MOV	ES,AX
	MOV	SI,80H			;PSP cmdline
	MOV	CL,[SI]			;cmdline length
;v1.1	MOV	CH,0
	xor	ch,ch			;clear msb
	PUSH	CX			;save cmdline length
	INC	SI			;bump to space beyond length
	MOV	DI,OFFSET cmdline_4C2	;cmdline buffer
	REPZ	MOVSB
	MOV	BYTE PTR [DI],0		;Asciize

	POP	CX			;cmdline length
	MOV	SI,OFFSET cmdline_4C2
	MOV	argc440,0
	MOV	BX,OFFSET argv442	;argv[] array
	mov	al,20H			;constant for scanning		v1.1
Lup417:
;v1.1	MOV	AL,20H	;' '		;gobble leading spaces
	XCHG	SI,DI
	REPZ	SCASB			;scan for ' '
	DEC	DI			;back up to it
	XCHG	SI,DI			;swap
	JCXZ	GetParms_X		;zeroed out cmdline, done
	MOV	[BX],SI			;save pointer to parm[argc]
	ADD	BX,2			;bump to next parm[]
	INC	argc440			;inc parm counter
;v1.1	MOV	AL,20H	;' '
	XCHG	SI,DI			;swap back
	REPNZ	SCASB			;find next separator
	DEC	DI			;back up to it
	XCHG	SI,DI			;swap
	JCXZ	GetParms_X		;zeroed out cmdline, done
	MOV	BYTE PTR [SI],0		;AsciiZ the string
	INC	SI			;bump to next char
	DEC	CX			;adjust counter
	JMP	SHORT	Lup417		;next parm, please

GetParms_X:
;dumb	POP	ES
;dumb	POP	DS
	RET
GetParms_3F0	ENDP

;v1.1	Moved these variables down to code end to be dynamic.

;argc440	db	0		;was word			v1.1
;;Array of pointers to cmdline args
;;argv[]
;argv442	DB	80H DUP(0)
;cmdline_4C2	DB	5AH DUP(0)
;	DB	34H DUP(0)

;Convert ASCII string at SI to binary integer in CX
AtoB_550	PROC	NEAR
	PUSH	BX
	MOV	BX,0AH			;constant multiplier
;v1.1	MOV	CX,0
	xor	cx,cx	;0		;initialize			v1.1

Lup557:	MOV	AL,[SI]			;snarf the char
	CMP	AL,'0'
	JB	Ret56D
	CMP	AL,'9'
	JA	Ret56D
	SUB	AL,30H	;'0'		;Deasciify
	CBW
	XCHG	CX,AX
	IMUL	BX			;*10
	ADD	AX,CX
	XCHG	CX,AX			;accumulate in CX
	INC	SI			;next char
	JMP	SHORT	Lup557

Ret56D:	POP	BX
	RET	;_NEAR
AtoB_550	ENDP


;argc440	db	0			;was word		v1.1
;;Array of pointers to cmdline args
;;argv[]
;argv442	DB	80H DUP(0)
;cmdline_4C2	DB	5AH DUP(0)
;	DB	34H DUP(0)
argc440	label	byte
argv442		EQU	word ptr argc440+1		;128 bytes
cmdline_4C2	EQU	byte ptr argc440+129

CSEG	ENDS
	END	FDate2
