/*****************************************************************
*  VerID.C
*  written by Kathy Cea, Platinum Software Int'l
*
*  Verifies an application id/user id combination for
*  the user calling the program.  Designed to be used from a
*  batch file.
*
*  Calling Syntax:
*       VerID <appl-id> <user-id>
*         where <appl-id> is the name given to the application (note
*                         that this must match the name used in the
*                         AddID program)
*               <user-id> is the user's id for the application
*                         (again, this must match the id assigned to
*                         the user through the AddID program).
*
*  Returns:
*     0 - Match (successful)
*     1 - No match
*     2 - Can't read property Value
*     3 - Too few parameters supplied
*
*   Compiled in Turbo C 2.0 with NetWare C function calls
*****************************************************************/

#include <stdio.h>
#include <nit.h>
#include <niterror.h>

WORD ConnectNumber;
long objectID;
BYTE loginTime[7];
char objectName[48];
WORD objectType;
char propertyName[16];
char applName[13];
BYTE propertyFlags;
BYTE submitValue[128],
     actualValue[128];
BYTE moreSegments;
int retcode;
int segNum = 1;

main(int argc, char *argv[])
{
   if(argc < 3) {
        printf("Too few parameters supplied\n");
        exit(3);
    }

    strcpy(applName,strupr(argv[1]));
    strcpy(submitValue,strupr(argv[2]));
    strcpy(propertyName,applName);
    strcat(propertyName,"ID");

/* Get user's object name */
    ConnectNumber =  GetConnectionNumber();
    GetConnectionInformation(ConnectNumber, objectName,
            &objectType, &objectID,loginTime);

/* Get the application ID property value */
    retcode = ReadPropertyValue(objectName,objectType,propertyName,segNum,
                actualValue,&moreSegments,&propertyFlags);
    if (retcode != SUCCESSFUL) /* Can't read value */
        exit(2);

/* Compare submitted ID with ID found in bindery */
    if (!stricmp(submitValue,actualValue)) /* Match */
        exit(0);
    else /* No match */
        exit(1);
}

