/*****************************************************************
*  InGroup.C
*  written by Kathy Cea, Platinum Software Int'l
*
*  InGroup is a utility to check whether the user is a member of
*  a specified group. Designed to be used from a DOS batch file.
*
*  Calling Syntax:
*     InGroup <group-name>
*        <group-name> - The name of the group to be checked
*
*   Returns the following:
*       0 - User is member of group
*       1 - No group name was supplied on the command line
*       2 - User is not a member of group
*       3 - Group does not exist
*       4 - Other error
*
*   Compiled in Turbo C 2.0 with NetWare C function calls
*****************************************************************/

#include <stdio.h>
#include <nit.h>
#include <niterror.h>

WORD ConnectNumber;
char objectName[48],groupname[48];
WORD objectType;
long objectID;
BYTE loginTime[7];

main(int argc, char *argv[])
{
       if(argc < 2) {
            printf("No group name supplied\n");
            exit(1);
    }
    strcpy(groupname, argv[1]);

/* Get user's object name */
    ConnectNumber =  GetConnectionNumber();
    GetConnectionInformation(ConnectNumber, objectName,
            &objectType, &objectID,loginTime);

    switch(IsBinderyObjectInSet(groupname, OT_USER_GROUP,"GROUP_MEMBERS",
            objectName, OT_USER)){
        case SUCCESSFUL:
            exit(0);
        case NO_SUCH_MEMBER:
            exit(2);
        case NO_SUCH_OBJECT:
            exit(3);
        default:
            exit(4);
        }
}

