/*
        Custom Computer Consultants
        Universal Cross Assembler
        6805 Symbols
        5 April 1985
*/

#include <stdio.h>
#include <uasm.h>

char   *version = {"6805 Assembler -- V3.2  4/5/86\n"} ;

#define CSEG    1       /*      Code Segment            */
#define DSEG    2       /*      Data Segment            */
#define ASCII   4       /*      String                  */
#define PAGE    5       /*      Page Eject              */
#define RADIX   6       /*      Define Radix            */
#define DB      8       /*      Define Byte             */
#define DS      9       /*      Define Storage          */
#define DW      10      /*      Define Word             */
#define EQU     11      /*      Equate                  */
#define ORG     12      /*      Origin                  */

extern int     pass1 ;
extern int     lbl ;
extern int     i, j, k ;
extern int     lnspp ;
extern int     cc ;
extern int     ilc ;
extern int     active ;
extern int     instl ;
extern int     parval ;
extern int     radix ;
extern int     cput ;
extern int     syte, sytx ;

extern unsigned        unpar ;
extern unsigned        ha, he, hsp ;

extern unsigned  char    ch ;
extern unsigned  char    sym ;

extern char    *iptr ;  
extern char    segtype[] ;

extern unsigned  char    ib[] ;
extern unsigned  char    pv[] ;
extern unsigned  char    px[] ;

extern           int     pj[] ;
extern           int     il[] ;
extern char    *pc[], *pseudo[] ;

extern int     (*pp[])() ;
extern int     (*ppo[])() ;

extern char    ibuf[] ;

extern struct  symbol  symtab[] ;

#define SYMTYPE  (symtab[sytx].flags&(NSEG-1))

code_seg() { return CSEG ; }

not_cseg(seg)
int    seg ;
{
       if( seg == DSEG ) return TRUE ;
       else return FALSE ;
}

set_il()
{
       il[CSEG] =    0x80 ;
       il[DSEG] =    0 ;
}

set_type()
{
       segtype[CSEG] = '\'' ;
       segtype[DSEG] = '\"' ;
}


gen(len)
int     len ;
{
        ib[2] = parval & 0xFF ;
        ib[1] = len == 3 ? parval >> 8 : ib[2] ;
        instl = len ;
        ib[0] = pv[k] ;
        return TRUE ;
}               

nopr()  { return gen(1) ; }

immd()  { if( nomatch("#") )            return FALSE ;
          parval = eval() ;
          return gen(2) ; }

dira()  { parval = eval() ;
          if( ch == ',' )               return FALSE ;
          return gen(2) ;  }

dorc()  { parval = eval() ;
          if( ch == ',' )               return FALSE ;
          gen(3) ;
          if( ib[1] )                   return TRUE  ;
          ib[0] -= 0x10 ;
          ib[1] = ib[2] ;
          --instl ;                     return TRUE  ; }

inx0()  { if( nomatch(",X") )           return FALSE ;
          return gen(1) ;  }

inx1()  { parval = eval() ;
          if( nomatch(",X") )           return FALSE ;
          return gen(2) ;  }

indx()  { parval = eval() ;
          if( nomatch(",X") )           return FALSE ;
          gen(3) ;
          if( ib[1] )                   return TRUE  ;
          ib[0] += 0x10 ;
          ib[1] = ib[2] ;
          --instl ;                     return TRUE  ; }

rela()  { crela(2) ;
          return gen(2) ; }

crela(n)
int     n ;
{
        parval = eval() - ( ilc + n ) ;
        if( parval > 127 || parval < -128 ) push('R') ;
}

bada()  { unpar = 2 * eval() ;
          if( notcomma() )              return FALSE ;
          parval = eval() ;
          gen(2) ;
          ib[0] |= ( unpar & 0x0E ) ;   return TRUE  ; }

bdrl()  { unpar = 2 * eval() ;
          if( notcomma() )              return FALSE ;
          parval = eval() ;
          if( notcomma() )              return FALSE ;
          gen(2) ;
          ib[0] |= ( unpar & 0x0E ) ;
          crela(3) ;
          ib[2] = parval & 0xFF ;
          instl = 3 ;                   return TRUE  ; }

areg()  { if( nomatch("A") )            return FALSE ;
          return gen(1) ; }

xreg()  { if( nomatch("X") )            return FALSE ;
          return gen(1) ; }


#define INFO     1
#define NOINFO   0

doseg()
{
       il[active] = ilc ;
       ilc = il[j] ;
       active = j ;
       return NOINFO ;
}

dods()
{
       instl = eval() ;
       return NOINFO ;
}

dodw()
{                
       parval = eval() ;
       ib[cput++] = parval >> 8 ;
       ib[cput++] = parval & 0xFF ;
       while ( sym == ',' ) {
         getch() ;
         parval = eval() ;
         ib[cput++] = parval >> 8 ;
         ib[cput++] = parval & 0xFF ;
         }
       instl = cput ;
       return INFO ;
}

dodb()
{
       parval = eval() ;
       ib[cput++] = parval & 0xFF ;
       while ( sym == ',' ) {
         getch() ;
         ib[cput++] = eval() & 0xFF ;
         }
       instl = cput ;
       return INFO ;
}                            


doequ()
{
       parval = eval() ;
       if ( pass1 && (lbl == OK) ) {
         symtab[syte-1].value = parval ;
         symtab[syte-1].flags = active ;
         }
       return NOINFO ;
}

doorg()
{
       parval = eval() ;
       ilc = parval ;
       if ( hsp == 0 ) ha = he = ilc ;
       return NOINFO ;
}

dopage()
{
       lnspp = 0 ;
       return NOINFO ;
}

doradix()
{
       radix = parval ;
       return NOINFO ;
}

doascii()
{
       while( isin(ch," \t") ) getch() ;
       sym = ch ; getch() ;
       while( ch != sym && ch != '\n' ) {
         ib[cput++] = ch ;
         getch() ;
         }
       ib[cput++] = EOS ;
       instl = cput ;
       return INFO ;
}

/*
        build_pseudo -- build a table of pointers to pseudo-ops
*/

build_pseudo()
{
        
        j = -1 ;
        pseudo[++j] = "ASCII" ; pj[j] = ASCII ; ppo[ASCII] = doascii ;
        pseudo[++j] = "CSEG"  ; pj[j] = CSEG  ; ppo[CSEG]  = doseg   ;
        pseudo[++j] = "DB"    ; pj[j] = DB    ; ppo[DB]    = dodb    ;
        pseudo[++j] = "DS"    ; pj[j] = DS    ; ppo[DS]    = dods    ;
        pseudo[++j] = "DSEG"  ; pj[j] = DSEG  ; ppo[DSEG]  = doseg   ;
        pseudo[++j] = "DW"    ; pj[j] = DW    ; ppo[DW]    = dodw    ;
        pseudo[++j] = "EQU"   ; pj[j] = EQU   ; ppo[EQU]   = doequ   ;
        pseudo[++j] = "ORG"   ; pj[j] = ORG   ; ppo[ORG]   = doorg   ;
        pseudo[++j] = "PAGE"  ; pj[j] = PAGE  ; ppo[PAGE]  = dopage  ;
        pseudo[++j] = "RADIX" ; pj[j] = RADIX ; ppo[RADIX] = doradix ;
        return ++j ;
}


/*
        buildopc -- build opcode definition tables
                pc - opcode strings
                px - index by opcode into opcode values & post processing
                pv - opcode values
                pp - post processing functions
*/
buildopc()
{


        i = j = 0 ;

        pc[i]="ADC"   ; px[i++]=j ;     pv[j]=0xA9 ; pp[j++]=immd ;
                                        pv[j]=0xF9 ; pp[j++]=inx0 ;
                                        pv[j]=0xC9 ; pp[j++]=dorc ;
                                        pv[j]=0xD9 ; pp[j++]=indx ;

        pc[i]="ADD"   ; px[i++]=j ;     pv[j]=0xAB ; pp[j++]=immd ;
                                        pv[j]=0xFB ; pp[j++]=inx0 ;
                                        pv[j]=0xCB ; pp[j++]=dorc ;
                                        pv[j]=0xDB ; pp[j++]=indx ;

        pc[i]="AND"   ; px[i++]=j ;     pv[j]=0xA4 ; pp[j++]=immd ;
                                        pv[j]=0xF4 ; pp[j++]=inx0 ;
                                        pv[j]=0xC4 ; pp[j++]=dorc ;
                                        pv[j]=0xD4 ; pp[j++]=indx ;

        pc[i]="ASL"   ; px[i++]=j ;     pv[j]=0x48 ; pp[j++]=areg ;
                                        pv[j]=0x58 ; pp[j++]=xreg ;
                                        pv[j]=0x78 ; pp[j++]=inx0 ;
                                        pv[j]=0x38 ; pp[j++]=dira ;
                                        pv[j]=0x68 ; pp[j++]=inx1 ;

        pc[i]="ASR"   ; px[i++]=j ;     pv[j]=0x47 ; pp[j++]=areg ;
                                        pv[j]=0x57 ; pp[j++]=xreg ;
                                        pv[j]=0x77 ; pp[j++]=inx0 ;
                                        pv[j]=0x37 ; pp[j++]=dira ;
                                        pv[j]=0x67 ; pp[j++]=inx1 ;


        pc[i]="BCC"   ; px[i++]=j ;     pv[j]=0x24 ; pp[j++]=rela ;
        pc[i]="BCLR"  ; px[i++]=j ;     pv[j]=0x11 ; pp[j++]=bada ;
        pc[i]="BCS"   ; px[i++]=j ;     pv[j]=0x25 ; pp[j++]=rela ;
        pc[i]="BEQ"   ; px[i++]=j ;     pv[j]=0x27 ; pp[j++]=rela ;
        pc[i]="BHCC"  ; px[i++]=j ;     pv[j]=0x28 ; pp[j++]=rela ;
        pc[i]="BHCS"  ; px[i++]=j ;     pv[j]=0x29 ; pp[j++]=rela ;
        pc[i]="BHI"   ; px[i++]=j ;     pv[j]=0x22 ; pp[j++]=rela ;
        pc[i]="BHS"   ; px[i++]=j ;     pv[j]=0x24 ; pp[j++]=rela ;
        pc[i]="BIH"   ; px[i++]=j ;     pv[j]=0x2F ; pp[j++]=rela ;
        pc[i]="BIL"   ; px[i++]=j ;     pv[j]=0x2E ; pp[j++]=rela ;
        pc[i]="BIL"   ; px[i++]=j ;     pv[j]=0x2E ; pp[j++]=rela ;

        pc[i]="BIT"   ; px[i++]=j ;     pv[j]=0xA5 ; pp[j++]=immd ;
                                        pv[j]=0xF5 ; pp[j++]=inx0 ;
                                        pv[j]=0xC5 ; pp[j++]=dorc ;
                                        pv[j]=0xD5 ; pp[j++]=indx ;

        pc[i]="BLO"   ; px[i++]=j ;     pv[j]=0x25 ; pp[j++]=rela ;
        pc[i]="BLS"   ; px[i++]=j ;     pv[j]=0x23 ; pp[j++]=rela ;
        pc[i]="BMC"   ; px[i++]=j ;     pv[j]=0x2C ; pp[j++]=rela ;
        pc[i]="BMI"   ; px[i++]=j ;     pv[j]=0x2B ; pp[j++]=rela ;
        pc[i]="BMS"   ; px[i++]=j ;     pv[j]=0x2D ; pp[j++]=rela ;
        pc[i]="BNE"   ; px[i++]=j ;     pv[j]=0x26 ; pp[j++]=rela ;
        pc[i]="BPL"   ; px[i++]=j ;     pv[j]=0x2A ; pp[j++]=rela ;
        pc[i]="BRA"   ; px[i++]=j ;     pv[j]=0x20 ; pp[j++]=rela ;
        pc[i]="BRCLR" ; px[i++]=j ;     pv[j]=0x01 ; pp[j++]=bdrl ;
        pc[i]="BRN"   ; px[i++]=j ;     pv[j]=0x21 ; pp[j++]=rela ;

        pc[i]="BRSET" ; px[i++]=j ;     pv[j]=0x00 ; pp[j++]=bdrl ;

        pc[i]="BSET"  ; px[i++]=j ;     pv[j]=0x10 ; pp[j++]=bada ;


        pc[i]="BSR"   ; px[i++]=j ;     pv[j]=0xAD ; pp[j++]=rela ;

        pc[i]="CLC"   ; px[i++]=j ;     pv[j]=0x98 ; pp[j++]=nopr ;
        pc[i]="CLI"   ; px[i++]=j ;     pv[j]=0x9A ; pp[j++]=nopr ;

        pc[i]="CLR"   ; px[i++]=j ;     pv[j]=0x4F ; pp[j++]=areg ;
                                        pv[j]=0x5F ; pp[j++]=xreg ;
                                        pv[j]=0x7F ; pp[j++]=inx0 ;
                                        pv[j]=0x3F ; pp[j++]=dira ;
                                        pv[j]=0x6F ; pp[j++]=inx1 ;

        pc[i]="CMP"   ; px[i++]=j ;     pv[j]=0xA1 ; pp[j++]=immd ;
                                        pv[j]=0xF1 ; pp[j++]=inx0 ;
                                        pv[j]=0xC1 ; pp[j++]=dorc ;
                                        pv[j]=0xD1 ; pp[j++]=indx ;

        pc[i]="COM"   ; px[i++]=j ;     pv[j]=0x43 ; pp[j++]=areg ;
                                        pv[j]=0x53 ; pp[j++]=xreg ;
                                        pv[j]=0x73 ; pp[j++]=inx0 ;
                                        pv[j]=0x33 ; pp[j++]=dira ;
                                        pv[j]=0x63 ; pp[j++]=inx1 ;

        pc[i]="CPX"   ; px[i++]=j ;     pv[j]=0xA3 ; pp[j++]=immd ;
                                        pv[j]=0xF3 ; pp[j++]=inx0 ;
                                        pv[j]=0xC3 ; pp[j++]=dorc ;
                                        pv[j]=0xD3 ; pp[j++]=indx ;

        pc[i]="DEC"   ; px[i++]=j ;     pv[j]=0x4A ; pp[j++]=areg ;
                                        pv[j]=0x5A ; pp[j++]=xreg ;
                                        pv[j]=0x7A ; pp[j++]=inx0 ;
                                        pv[j]=0x3A ; pp[j++]=dira ;
                                        pv[j]=0x6A ; pp[j++]=inx1 ;

        pc[i]="EOR"   ; px[i++]=j ;     pv[j]=0xA8 ; pp[j++]=immd ;
                                        pv[j]=0xF8 ; pp[j++]=inx0 ;
                                        pv[j]=0xC8 ; pp[j++]=dorc ;
                                        pv[j]=0xD8 ; pp[j++]=indx ;

        pc[i]="INC"   ; px[i++]=j ;     pv[j]=0x4C ; pp[j++]=areg ;
                                        pv[j]=0x5C ; pp[j++]=xreg ;
                                        pv[j]=0x7C ; pp[j++]=inx0 ;
                                        pv[j]=0x3C ; pp[j++]=dira ;
                                        pv[j]=0x6C ; pp[j++]=inx1 ;

        pc[i]="JMP"   ; px[i++]=j ;     pv[j]=0xFC ; pp[j++]=inx0 ;
                                        pv[j]=0xCC ; pp[j++]=dorc ;
                                        pv[j]=0xDC ; pp[j++]=indx ;


        pc[i]="JSR"   ; px[i++]=j ;     pv[j]=0xFD ; pp[j++]=inx0 ;
                                        pv[j]=0xCD ; pp[j++]=dorc ;
                                        pv[j]=0xDD ; pp[j++]=indx ;

        pc[i]="LDA"   ; px[i++]=j ;     pv[j]=0xA6 ; pp[j++]=immd ;
                                        pv[j]=0xF6 ; pp[j++]=inx0 ;
                                        pv[j]=0xC6 ; pp[j++]=dorc ;
                                        pv[j]=0xD6 ; pp[j++]=indx ;

        pc[i]="LDX"   ; px[i++]=j ;     pv[j]=0xAE ; pp[j++]=immd ;
                                        pv[j]=0xFE ; pp[j++]=inx0 ;
                                        pv[j]=0xCE ; pp[j++]=dorc ;
                                        pv[j]=0xDE ; pp[j++]=indx ;

        pc[i]="LSL"   ; px[i++]=j ;     pv[j]=0x48 ; pp[j++]=areg ;
                                        pv[j]=0x58 ; pp[j++]=xreg ;
                                        pv[j]=0x78 ; pp[j++]=inx0 ;
                                        pv[j]=0x38 ; pp[j++]=dira ;
                                        pv[j]=0x68 ; pp[j++]=inx1 ;

        pc[i]="LSR"   ; px[i++]=j ;     pv[j]=0x44 ; pp[j++]=areg ;
                                        pv[j]=0x54 ; pp[j++]=xreg ;
                                        pv[j]=0x74 ; pp[j++]=inx0 ;
                                        pv[j]=0x34 ; pp[j++]=dira ;
                                        pv[j]=0x64 ; pp[j++]=inx1 ;


        pc[i]="NEG"   ; px[i++]=j ;     pv[j]=0x40 ; pp[j++]=areg ;
                                        pv[j]=0x50 ; pp[j++]=xreg ;
                                        pv[j]=0x70 ; pp[j++]=inx0 ;
                                        pv[j]=0x30 ; pp[j++]=dira ;
                                        pv[j]=0x60 ; pp[j++]=inx1 ;

        pc[i]="NOP"   ; px[i++]=j ;     pv[j]=0x9D ; pp[j++]=nopr ;

        pc[i]="ORA"   ; px[i++]=j ;     pv[j]=0xAA ; pp[j++]=immd ;
                                        pv[j]=0xFA ; pp[j++]=inx0 ;
                                        pv[j]=0xCA ; pp[j++]=dorc ;
                                        pv[j]=0xDA ; pp[j++]=indx ;

        pc[i]="ROL"   ; px[i++]=j ;     pv[j]=0x49 ; pp[j++]=areg ;
                                        pv[j]=0x59 ; pp[j++]=xreg ;
                                        pv[j]=0x79 ; pp[j++]=inx0 ;
                                        pv[j]=0x39 ; pp[j++]=dira ;
                                        pv[j]=0x69 ; pp[j++]=inx1 ;

        pc[i]="ROR"   ; px[i++]=j ;     pv[j]=0x46 ; pp[j++]=areg ;
                                        pv[j]=0x56 ; pp[j++]=xreg ;
                                        pv[j]=0x76 ; pp[j++]=inx0 ;
                                        pv[j]=0x36 ; pp[j++]=dira ;
                                        pv[j]=0x66 ; pp[j++]=inx1 ;

        pc[i]="RSP"   ; px[i++]=j ;     pv[j]=0x98 ; pp[j++]=nopr ;
        pc[i]="RTI"   ; px[i++]=j ;     pv[j]=0x80 ; pp[j++]=nopr ;
        pc[i]="RTS"   ; px[i++]=j ;     pv[j]=0x81 ; pp[j++]=nopr ;

        pc[i]="SBC"   ; px[i++]=j ;     pv[j]=0xA2 ; pp[j++]=immd ;
                                        pv[j]=0xF2 ; pp[j++]=inx0 ;
                                        pv[j]=0xC2 ; pp[j++]=dorc ;
                                        pv[j]=0xD2 ; pp[j++]=indx ;

        pc[i]="SEC"   ; px[i++]=j ;     pv[j]=0x99 ; pp[j++]=nopr ;
        pc[i]="SEI"   ; px[i++]=j ;     pv[j]=0x9B ; pp[j++]=nopr ;

        pc[i]="STA"   ; px[i++]=j ;     pv[j]=0xF7 ; pp[j++]=inx0 ;
                                        pv[j]=0xC7 ; pp[j++]=dorc ;
                                        pv[j]=0xD7 ; pp[j++]=indx ;


        pc[i]="STOP"  ; px[i++]=j ;     pv[j]=0x8E ; pp[j++]=nopr ;

        pc[i]="STX"   ; px[i++]=j ;     pv[j]=0xFF ; pp[j++]=inx0 ;
                                        pv[j]=0xCF ; pp[j++]=dorc ;
                                        pv[j]=0xDF ; pp[j++]=indx ;

        pc[i]="SUB"   ; px[i++]=j ;     pv[j]=0xA0 ; pp[j++]=immd ;
                                        pv[j]=0xF0 ; pp[j++]=inx0 ;
                                        pv[j]=0xC0 ; pp[j++]=dorc ;
                                        pv[j]=0xD0 ; pp[j++]=indx ;

        pc[i]="SWI"   ; px[i++]=j ;     pv[j]=0x83 ; pp[j++]=nopr ;
        pc[i]="TAX"   ; px[i++]=j ;     pv[j]=0x97 ; pp[j++]=nopr ;

        pc[i]="TST"   ; px[i++]=j ;     pv[j]=0x4D ; pp[j++]=areg ;
                                        pv[j]=0x5D ; pp[j++]=xreg ;
                                        pv[j]=0x7D ; pp[j++]=inx0 ;
                                        pv[j]=0x3D ; pp[j++]=dira ;
                                        pv[j]=0x6D ; pp[j++]=inx1 ;

        pc[i]="TXA"   ; px[i++]=j ;     pv[j]=0x9F ; pp[j++]=nopr ;
        pc[i]="WAIT"  ; px[i++]=j ;     pv[j]=0x8F ; pp[j++]=nopr ;
                         px[i] = j ;
        return i ;
}



/*
        End of 6805sym.c
*/

