#include <dos.h>
#include <string.h>

#define TRUE 1
#define FALSE 0

#define ALTA 30
#define ALTB 48
#define ALTC 46
#define ALTD 32
#define ALTE 18
#define ALTF 33
#define ALTG 34
#define ALTH 35
#define ALTI 23
#define ALTJ 36
#define ALTK 37
#define ALTL 38
#define ALTM 50
#define ALTN 49
#define ALTO 24
#define ALTP 25
#define ALTQ 16
#define ALTR 19
#define ALTS 31
#define ALTT 20
#define ALTU 22
#define ALTV 47
#define ALTW 17
#define ALTX 45
#define ALTY 21
#define ALTZ 44

#define ALT1 120
#define ALT2 121
#define ALT3 122
#define ALT4 123
#define ALT5 124
#define ALT6 125
#define ALT7 126
#define ALT8 127
#define ALT9 128
#define ALT0 129

#define ALTMINUS  130
#define ALTPLUS   131

//LIB
void vprintat(int cols,int rows,int fore,int back,char *,...);
void vprintc(int row,int fore,int back,char *,...);
void printat(int,int,int,int,char *);
void printc(int,int,int,char *);
void cprintat(int,int,int,int,char *,...);
void cprintc(int,int,int,char *,...);
void clear(char ch,int fore,int back);
void cursoroff();
void cursoron();
void settext(int,int);
void chsattr(int,int);
void chcattr(int,int,int,int,int);
void dlay(int ticks);
long getticks();
int altkey();
int ctrlkey();
int lshiftkey();
int rshiftkey();
void flushkeys();
unsigned char getvidmode();

//MOUSECLASS
class Mcursor {
	  int shown;
	  int current;
	  int xpos;
	  int ypos;
	  void mouse_interrupt();
	  int m1;
	  int m2;
	  int m3;
	  int m4;
	  int button;
	  int count;
	  long tickcount;
	  int disabled;
	public:
	  int  init();
	  void get_status();
	  void show();
	  void hide();
	  void set_hor_bounds(int,int);
	  void set_ver_bounds(int,int);
	  void Mcursor::conditional_off(int x1,int y1,int x2,int y2);
	  void Mcursor::position(int,int);
	  int  LBP();
	  int  RBP();
	  int  mousex();
	  int  mousey();
	  int  mx();
	  int  my();
	  void unarm();
	  void arm();
	  int  LBDCLK();
	  };

#define UPARROW 1
#define DOT 2
#define PENCIL 3
#define CROSSHAIR 4
#define ARROW 5
#define FINGER 6
#define POINT 7
#define CLOCK 8
#define DISK 9
#define IBAR 10
#define PAINTCAN 11
#define HAND 12
#define ERASOR 13
#define GUNSIGHT 14
#define SCISSORS 15
#define JAWS 16

//WINDOW
//typedef unsigned char screenbuff[4000];
typedef char itemarray[24][80];

#define SINGLE 0
#define DOUBLE 1
#define HOR 0
#define VER 1

class Twindow{
	protected:
		int x;
		int y;
		int x1;
		int y1;
		int fgd;
		int bgd;
		int shad;
		int shadcolor;
		int size;
		char id[15];
		int existtitle;
		int bordertype;
		int shown;
		unsigned char *save;
	public:
		Twindow();
		~Twindow();
		void getstyle();
		void init(int xpos,int ypos,int x1pos,int y1pos,
		int fore,int back,int shadow,int shadowcolor);
		void border();
		void setborder(int style);
		int  getborder();
		void cfgd(int fore);
		void cbgd(int back);
		int  getfgd();
		int  getbgd();
		void fill();
		void divider(int direction,int style,int offset);
		void show();
		void zoom();
		void hide();
		void elim();
		void title(char txt[15]);
		int  istitle();
		int isshown();
		int isx();
		int isy();
		int isx1();
		int isy1();
		int issize();
		void wprintat(int,int,int,int,char*);
		void wprintc(int,int,int,char*);
		};

class Tmenu:public Twindow{
	protected:
		int itemcount;
		itemarray items;
		int hifore;
		int hiback;
		int menuchoice;
	public:
		void init(int itemcnt,itemarray item,int xpos,int ypos,int width,
		int fore,int back,int hfore,int hback,
		int shadow,int shadowcolor);
		int show();
		void move(int xpos,int ypos);
		};

//INPUT
void beep();
char *strdel(char *,int);
char *strins(char *,int,char);

class Tstring {
	protected:
		char laststring[81];
		char bar[81];
		int xpos;
		int x;
		int y;
		int length;
		int ucase;
		int escape;
		int retrn;
		int tab;
		int uparrow;
		int dnarrow;
		int shown;
		int barred;
		int firstchar;
		int infgd;
		int inbgd;
	public:
		Tstring();
		~Tstring();
		void init(int xloc,int yloc,int len,int uppercase);
		void show();
		void input();
		void get_input();
		void get_form_input();
		void get_form_mouse_input();
		void reset();
		void preset(char *);
		void erase(int);
		char *getstring();
		int escapehit();
		int returnhit();
		int tabhit();
		int uparrowhit();
		int dnarrowhit();
		int isshown();
		int isbarred();
		int hit();
		void setincolors(int,int);
		};

class Tnumeral:public Tstring {
	protected:
		int real;
		int end;
	public:
		void init(int xloc,int yloc,int len,int int_or_float);
		void show();
		void get_input();
		void get_form_input();
		void get_form_mouse_input();
		void input();
		float getfloat();
		int getint();
		long getlong();
		};

class Tdate:public Tstring {
	protected:
		int date_ok;
	public:
		void init(int xloc,int yloc);
		void show();
		void get_input();
		void validate();
		int  verified();
		char *getdatestring();
		long getdate();
		};

//TBUTTON
class Tbutton {
	protected:
		int xpos;
		int ypos;
		int width;
		int pressed;
		int hilite;
		char button[81];
		char shadow[81];
		char id[41];
	public:
		Tbutton();
		void init(int,int,char *,int);
		~Tbutton();
		void show(int);
		int buttonpressed();
		int hit();
		void press(int);
		int ispressed();
		};

class Tcheckbox {
	protected:
		int xpos;
		int ypos;
		int fgd;
		int bgd;
		int checked;
	public:
		Tcheckbox();
		void init(int,int,int,int);
		~Tcheckbox();
		void show();
		void grabcursor();
		int hit();
		void check();
		void uncheck();
		int ischecked();
		};

//MISC
void smover(int row,int startpos,int endpos,int fgd,int bgd,char *string);
void smovel(int row,int startpos,int endpos,int fgd,int bgd,char *string);
void smoveu(int col,int startpos,int endpos,int fgd,int bgd,char *string);
void smoved(int col,int startpos,int endpos,int fgd,int bgd,char *string);

//SOUNDQ
#define TimerTick 0x8
#define noisemax 8192
#define ON 1
#define OFF 0

#define C 523
#define CS 554
#define D 587
#define DS 622
#define E 659
#define F 698
#define FS 740
#define G 784
#define GS 831
#define A 880
#define AS 932
#define B 988
#define C1 1046

#define SN 32
#define EN 63
#define QN 125
#define HN 250
#define WN 500

#define ENT 20
#define QNT 41
#define HNT 83

#define BN 30000,5
#define SR 30000,32
#define ER 30000,63
#define QR 30000,125
#define HR 30000,250
#define WR 30000,500
#define NM 30000,1

class SoundQ{
	protected:
		float speed_factor;
	public:
		SoundQ();
		~SoundQ();
		void play(int,int);
		void adjust_speed(float);
		};

typedef struct
{
  int duration;
  int freq;
} noise;

void empty_sound_queue();
void init_sound(void);
void restore_sound(void);
int submit_sound(int freq,int delay);
void interrupt soundsystem(...);
