/****************************************************************************/
/*                                                                          */
/* PRT_HELP.C 																														  */
/*																													                */
/* This program will take a hypertext help file, strip out any commands,    */
/* print it to the screen as straight ASCII text.                           */
/* If you wish to convert the help file to a simple text file, just re-     */
/* direct the output to a file!  For example, to convert UW_HELP0.HLP to    */
/* UW_HELP0.TXT, just type:                                                 */
/*                                                                          */
/* PRT_HELP UW_HELP0.HLP > UW_HELP0.TXT                                     */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef unsigned char uchar;
#define CMD_CHAR '`'

/*------------------------ prototypes for the program ----------------------*/
void remove_commands( char *s, char *d );
int cvt_tabs_to_spaces( char *s, int *text_len, int tab_size );
char *get_token( char *s, char *d, char delim, int mode );


/*********/
/* ~main */
/*       ********************************************************************/
/****************************************************************************/
int main( int argc, char *argv[] )
{
	int len;
	char buff[257], dest[257];
	FILE *fp;

	if( argc > 1 )
	{
		if( (fp = fopen(argv[1],"r")) != NULL )
		{
			setmem(buff,256,0);
			setmem(dest,256,0);
			while( fgets(buff, 256, fp) != NULL )
			{
				if( buff[0] == 12 || buff[0] == '\r' || buff[0] == '\n' )
					buff[0] = '\0';
				if( strlen(buff) > 2 )
				{
					remove_commands( buff, dest );
					cvt_tabs_to_spaces( dest, &len, 2 );
					strcpy( buff, dest );
				}
				printf("%s\n",buff);
			}
			fclose(fp);
		}
		return(1);
	}else
		printf("usage: prt_help filename\r\n");
	return(0);
}
/*** end of main ***/

/********************/
/* ~remove_commands */
/*                  *********************************************************/
/****************************************************************************/
void remove_commands( char *s, char *d )
{
	while( *s )
	{
		if( *s == CMD_CHAR )
		{
			if( toupper(*(s+1)) == 'K' )
			{
				while( *s && (*s != '(') ) s++;
				if( *s == '(' )
					s++;
				while( *s && (*s != ',') )
					*d++ = *s++;
				if( *s == ',' ) s++;
				while( *s && (*s != ';') ) s++;
				if( *s == ';' ) s++;
			}else{
				while( *s && (*s != ';')) s++;
				if( *s == ';' ) s++;
			}
		}else{
			if( *s && ((*s == 9) || (isascii(*s) && isprint(*s))) )
				*d++ = *s++;
			else
				*d++ = ' ', s++;
		}
	}
	*d = '\0';
}
/*** end of remove_commands ***/

/***********************/
/* ~cvt_tabs_to_spaces */
/*                     ******************************************************/
/****************************************************************************/
int cvt_tabs_to_spaces( char *s, int *text_len, int tab_size )
{
	char buffer[257], *save_s = s;
	char parm[81], parm2[81], function[81], *save_p;
	int i, cnt, len = 0, len1 = 0, len2;

	setmem(buffer,256,0);
	while( *s )
	{
		if( *s == 9 )
		{
			cnt = tab_size - (len % tab_size);
			for( i = 0; i < cnt; i++ )
				buffer[len++] = ' ';
			s++;
		}
		else if( *s == CMD_CHAR )
		{
			len2 = 0;
			save_p = s;
			s++;
			s = get_token(s, function, '(', 1);							/* get function name  */
			if( !strcmp(function, "KEYWORD") )
			{
				s = get_token(s, parm,  ',', 1);							/* get keyword    		*/
				s = get_token(s, parm2, ')', 0);							/* get search string	*/
				len2 = strlen(parm);													/* get keyword length	*/
			}
			s = save_p;
			do{
				buffer[len++] = *s, len1++;
			}while( *s++ != ';' );
			len1 -= len2;																		/* don't count keyword*/
		}else
			buffer[len++] = *s++;
	}
	if( len )
	{
		while( isascii(buffer[len-1]) && isspace(buffer[len-1]) )
			len--;
	}
	buffer[len] = '\0';
	strcpy(save_s, buffer);
	*text_len = len - len1;
	return(len);
}
/*** end of cvt_tabs_to_spaces ***/

/*************/
/*~get_token */
/*           ****************************************************************/
/* This routine extracts a "token" from the source string "s", stopping     */
/* when the character "delim" is reached".  A pointer to the character      */
/* following the delim is returned.                                         */
/* NOTE: The token is converted to uppercase as it is extracted and is      */
/*       NULL terminated...                                                 */
/****************************************************************************/
char *get_token( char *s, char *d, char delim, int mode )
{
	if( mode )																			/* convert to uppercase		*/
	{
		while( *s && (*s != delim) )
			*d++ = toupper(*s++);
	}else{
		while( *s && (*s != delim) )
			*d++ = *s++;
	}
	*d = '\0';
	return(s+1);
}
/*** end of get_token ***/

/*** END OF FILE ***/
