/*
 *                               TIMER.C
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 *
 *	The timer routines used here are little approximations
 *	since the Timer Interrupt ( 0x1C ) is only updated 18
 *  times a second.
 *
 *	The routines are NOT bulletproof - if you decide to use
 *	them I would heartily suggest you include a 
 *	Control Break (Interrupt 0x23) intercept routine
 *	to allow for cleanup before Going South...
 *
 *	There are basically three routines which you call
 *		timer_init () - sets up the timer interrupt vector
 *		                (the interrupt handler is imbedded in
 *		                 there somewhere).
 *
 *		timer_set () -  sets the timer counter to 0
 *
 *		timer_read () - returns the current value of the timer
 *		                counter.
 *
 *		timer_term () - a 'Must Do' - clean up our act and give
 *		                the interrupt vector back
 */
#include "dependnt.h"

#if (!defined (TRUE))
#	define TRUE  (1)
#	define FALSE (0)
#endif

volatile unsigned long int _Timer_cnt;
static int _Timer_Active = 0;

#if (defined (DLC))
int 
Timer_ISR ()
{
    _Timer_cnt++;
    return (0);
}
#else
void    (interrupt far * timer_save_vec) (void);
void interrupt far 
Timer_ISR (void)
{
	_Timer_cnt++;
	(*timer_save_vec) ();
}
#endif



/*
 *	TIMER_INIT
 */

int 
timer_init ()
{
    if (!_Timer_Active)
    {
#if (defined (DLC))
        int_intercept (0x1C, &Timer_ISR, 128);
#else
        timer_save_vec = getvect (0x1c);
        setvect (0x1C, Timer_ISR);
#endif
        _Timer_Active = TRUE;
    }
}



/*
 *	TIMER_TERM
 */

int 
timer_term ()
{
    if (_Timer_Active)
    {
#if (defined (DLC))
        int_restore (0x1C);
#else
        setvect (0x1C, timer_save_vec);
#endif
	    _Timer_Active = FALSE;
    }
}



/*
 *	TIMER_SET
 */

int 
timer_set ()
{
    _Timer_cnt = 0L;
}



/*
 *	TIMER_READ
 */

unsigned long int 
timer_read ()
{
    return (_Timer_cnt);
}




/*
 *	TIMEOUT - go away for the specified number of seconds
 */

int 
timeout (sec)
unsigned int sec;
{
    unsigned long int flag;
    sec *= 18;
    _Timer_cnt = 0L;
    do
    {
        flag = _Timer_cnt;
    } while (flag < sec);
}

static unsigned int DELAY_millisecond;
void
DELAY_init (void)
{
	static int d_init = 0;
	int        tna = 0;
    long    l;
    if (d_init)
    	return;
    d_init = 1;
	if (!_Timer_Active)
	{
		timer_init ();
		tna = 1;
	}
    timer_init ();
    timer_set ();
    while (timer_read () == 0L)
		;
    timer_set ();
    for (l = 0L; l != -1L; l++)
        if (timer_read () == 3)
            break;
    l *= 197;
    DELAY_millisecond = (int) ((l + 5000) / 10000);
    if (tna)
    	timer_term ();
}
static unsigned int _DELAY_cnt, _DELAY_ix;

int 
DELAY_loop (int msc)
{
    for (_DELAY_ix = 0; _DELAY_ix < msc; _DELAY_ix++)
        for (_DELAY_cnt = 0; _DELAY_cnt < DELAY_millisecond; _DELAY_cnt++)
			;
    return (msc);
}
