/*
 *                                MONITOR.C
 *
 *              A simple-Minded little Serial Port Monitor
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

#include <stdio.h>
#include "8250xon.h"
#include "monitor.h"
#include "options.h"
#include "_kb.h"

#define EOT 4
#define ETX 3
#define TRUE (1)
#define FALSE (0)
#if (!defined (DLC))
extern int cb_happened;
#endif

main (argc, argv)
int     argc;
char  **argv;
{
    int     ch;
    int     i;

    set_options (argc, argv);
    trap_ctrl_break ();
    timer_init ();
    xon8250_init (Port, 8192);
	fputs ("                  --  Monitor - RS232 Port Snooper  --\n", stdout);
    if (Cfg_Str [0])
    {
	    xon8250_port_init (Cfg_Str);
		fputs (Opt_Msg, stdout);
	}
	else
	{
		xon8250_port_enable ();
		fputs ("Using Default Port Settings\n", stdout);
	}
	fputs ("Use <Alt>F10 to exit\n", stdout);

    while (TRUE)
    {
        if ((ch = xon8250_read ()) != -1)
        {
        	xlate ((char) ch);
		}
        if ((ch = _kb ()) != -1)
        {
            if (ch == APF10)
            {
                xon8250_term ((Cfg_Str [0])?1:0);
                timer_term ();
                release_ctrl_break ();
                exit (0);
            }
            xon8250_write (ch);
        }
    }
}



int 
xlate (char c)
{
    static int lcnt = 0;
    static char *x_table[] = {
                     "<NUL>", "<SOH>", "<STX>", "<ETX>", "<EOT>", "<ENQ>",
                         "<ACK>", "<BEL>", "<BS>", "<HT>", "<LF>", "<VT>",
                         "<FF>", "<CR>", "<SO>", "<SI>", "<DLE>", "<DC1>",
                     "<DC2>", "<DC3>", "<DC4>", "<NAK>", "<SYN>", "<ETB>",
                        "<CAN>", "<EM>", "<SUB>", "<ESC>", "<FS>", "<GS>",
                              "<RS>", "<US>"
    };

    if (c < 32)
    {
        if (c == EOT)
        {
            putchar ('\n');
            lcnt = 0;
        }
        myputs (x_table[c]);
        lcnt += strlen (x_table[c]);
    }
    else
    {
        putchar (c);
        lcnt += 1;
    }
    if (lcnt > 79)
    {
        putchar ('\n');
        lcnt = 0;
    }
    fflush (stdout);
}

int 
myputs (s)
char   *s;
{
    while (*s)
        putchar (*s++);
}
