/*******************************************************************
* Customizing the graphics mouse cursor: code from Figure 4A   	*
*******************************************************************/
#include <conio.h>  /* kbhit(), getch()     */
#include <dos.h>    /* int86(), union REGS  */
#include <stdio.h>  /* puts()               */
#include <stdlib.h> /* exit(), EXIT_FAILURE */

void main(void)
    {
    union REGS regs;

    /* Initialize the mouse */
    regs.x.ax = 0x00;
    int86(0x33, &regs, &regs);
    if (!regs.x.ax)
        {
        puts("ERROR-can't initialize mouse");
        exit(EXIT_FAILURE);
        }

    /* Show the mouse */
    regs.x.ax = 0x01;
    int86(0x33, &regs, &regs);

    /* Wait for the user to quit */
    puts("You can now see the mouse");
    puts("Press any key to quit");
    while ( !kbhit() )
        ;

    /* Hide the mouse */
    regs.x.ax = 0x02;
    int86(0x33, &regs, &regs);
    }
