/*	makepath.c	CI-C86 Utility Function

	Copyright (c) 1985 by:

		Lawrence R. Steeger
		1009 North Jackson Street
		Milwaukee, Wisconsin 53202
		414-277-8149
*/

#include <stdio.h>

/*	makepath(filespec)

	Extract MS-DOS 2 drive/path name from "filespec".

	Returns:	(char *)	drive/path name or EOS
*/

char *makepath(filespec)
unsigned char *filespec;
{
	unsigned char delimit,		/* strrchr() delimiter		*/
		      *pathend,		/* end of drive:path\spec	*/
		      *strrchr();	/* reverse strchr()		*/

	char *alloc(),			/* storage allocator		*/
	     *pathname,			/* returned drive:path\name	*/
	     *strncpy();

	int pathlen;			/* length of drive:path\name	*/

	/*	determine drive/path delimiting character		*/

	delimit = 0;

	if (strrchr(filespec, '\\') != NULL)
		delimit = '\\';		/* drive:path\ specification	*/

	if (!delimit)
		if (strrchr(filespec, '/') != NULL)
			delimit = '/';	/* drive:path/ specification	*/
		else	delimit = ':';	/* drive: specification		*/

	/*	locate end of drive/path name				*/

	if ((pathend = strrchr(filespec, delimit)) != NULL) {
		pathlen = (pathend - filespec) + 1;
		pathname = alloc(pathlen + 1);
		return (strncpy(pathname, filespec, pathlen));
	}
	else {				/* no drive:path\name		*/
		pathname = alloc(1);
		*pathname = EOS;
		return (pathname);
	}
}

/*	end of makepath.c		*/

*