/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_gbool - get logical (True/False) from window 
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "windows.h"                    /* standard stuff */

/*
************
* wn_gbool *
************
*/

/*
** wn_gbool(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,ubuff,hlpmsg,errmsg)
**
**    int        fun - fucntion code (SET || XEQ)
**    (WIFORM)   frm - form pointer  (actual || NFRM)
**    int        fld - field # in form (actual || NFLD)
**    (WINDOWPTR) wn - window pointer
**    int        row - row in window where data input begins
**    int        col - col in window where data input begins
**    (char *) prmpt - field promt (call with NSTR for none)
**    unsigned atrib - field (not prompt) atributes 
**    char      fill - field fill character
**    (int *)  value - pointer to int for value (0=FALSE, 1=TRUE)
**    (char *) ubuff - pointer to char array of 3 bytes for editing 
**    (char *)hlpmsg - pointer to help message (call with NSTR for none)
**    (char *)errmsg - pointer to err message (call with NSTR) for none)
**
** RETURNS:
**
**    UBUFF with entered data via pointer.
**
**    NULL if error, else the non zero value returned from wn_input.
**
** NOTES:
**
**  FUN -   fun can only be SET for form setup, or XEQ for immediate
**          execution.  When called with SET, valid arguements for both
**          "frm" and "fld" must be specfied.  frm is the field pointer
**          returned from frmopn(), and fld is the field sequence number
**          in the form for this field.  When called with XEQ frm must
**          be NFRM and fld must NFLD.
**
**  UBUFF - Editing buffer.  Must be of sufficent size to hold the
**          data as it is entered.  Typical value is the length
**          of the mask + 2 bytes (strlen(mask)+2).
**
**          On entry, the first byte of ubuff should be 
**          a null, otherwise wn_input assumes there is valid
**          data there and will enter edit mode.  This can be 
**          handy if there is a need for prefilled but editable
**          fields.  In actual pratice, wn_input uses this
**          buffer for both initial character data entry and
**          subsequent editing.
**
**          On return, ubuff contains the actual data entered in
**          character format with fill and mask characters as
**          spaces (e.g. "T").
**
**  Calls wn_input to perform data entry.
**
**  User MUST enter T,F,Y, or N.
**
**  Data must satisfy validatin checks for function to return.
**
**  Calls wn_iemsg(errmsg) when vaildation fails.
**
*/

/*
************
* wn_gbool *
************
*/

wn_gbool(fun,frm,fld,wn,row,col,prmpt,atrib,fill,value,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int *value;                             /* the logical 0=FALSE, 1=TRUE */
char *ubuff;                            /* returns "value" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
char mask[3];                           /* Single char input */
int rv;                                 /* return value */

  if(fun != SET && fun != XEQ)          /* saftey check */
    return(NULL);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_gbool");             /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GBOOL;            /* function code */
    frm[fld]->v1.vip = value;           /* value */
    frm[fld]->v2.vcp = ubuff;           /* &ubuff */
    frm[fld]->v3.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v4.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

  strcpy(mask,"u");                     /* set mask */
begin:
  if(!(rv=wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
    *ubuff= NUL;                        /* indicate error */
    return(NULL);                       /* indicate error */
  }
  if(wni_frmflg) return(TRUE);          /* wn_frmget in progress */
  if(wns_escape) return(rv);            /* escape pressed ?? */
  if(*ubuff == 'T' || *ubuff == 'Y') {  /* T or Y = TRUE */
    *value = 1;                         /* set user value */
    return(rv);                         /* and return */
  }
  if(*ubuff == 'F' || *ubuff == 'N') {  /* F or N = FALSE */
    *value = 0;                         /* set user value */
    return(rv);                         /* and return */
  }
  wn_iemsg(errmsg);                     /* display error msg */
  goto begin;                           /* till we get it right */
}

/* End */
