/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <direct.h>
#include <string.h>
#include <stdlib.h>


#ifndef FA_LABEL
#define FA_LABEL  0x08
#endif

static int near vol_kill( int drive, char *vol )

{ union REGS regs;
  struct SREGS sregs;
  struct xfcb buf;
  char cdir[_MAX_PATH], dir[] = "x:\\\0           ";
  void far *ptr;

  if ( getcurdir(drive + 1, cdir) ) return -1;
  *dir = drive + 'A';
  if ( chdir(dir) ) { chdir( cdir ); return -1; }

  strncpy( &dir[2], vol, strlen(vol) );

  /* Parse the filename into an FCB */
  regs.h.ah = 0x29;
  regs.h.al = 0;
  sregs.ds  = FP_SEG( dir );
  regs.x.si = FP_OFF( dir );
  ptr = &buf.xfcb_fcb;
  sregs.es  = FP_SEG( ptr );
  regs.x.di = FP_OFF( ptr );
  intdosx( &regs, &regs, &sregs );

  if ( ! regs.h.al )
     {
       /* Volume labels require extended FCB's */
       buf.xfcb_flag = 0xff;
       buf.xfcb_attr = FA_LABEL;

       /* Delete the old label */
       regs.h.ah = 0x13;
       ptr = &buf;
       sregs.ds  = FP_SEG( ptr );
       regs.x.dx = FP_OFF( ptr );
       intdosx( &regs, &regs, &sregs );
     }

  chdir( cdir );

  return regs.h.al;
}



/***
 *
 *  Function   :    vollabel
 *
 *  Topics     :    Get/Set disk volume label
 *
 *  Parameters :    in       int drive         0 = A:, 1 = B:
 *                  in/out   char *vol         volume label
 *
 *  Decisions  :    - If *vol = '\0', it is filled with disk volume label.
 *                  - Otherwise, vol is copied onto disk volume label.
 *
 *  Return code:    0 if OK
 *                 -1 if error
 ***/

int vollabel( int drive, char *vol )

{ int result, fd;
  struct find_t finfo;
  char buf[20] = "A:\\*.*";

  *buf = drive + 'A';

  result = _dos_findfirst( buf, FA_LABEL, &finfo );

  if ( ! *vol )       /* only get the volume label */
     {
       if ( ! result )
          {
           /* suppress '.' */
           char *ptr;
           strcpy( vol, finfo.name );
           ptr = strchr( vol, '.' );
           strcpy( ptr, ptr + 1 );
          }
       return 0;
     }

  /* Delete volume label */
  if ( ! result )
     if ( vol_kill(drive, finfo.name) ) return -1;

  /* Construct absolute filename */
  strncpy( &buf[3], vol, 11 );

  /* Insert a '.' between 8th and 9th character */
  buf[14] = buf[13];
  buf[13] = buf[12];
  buf[12] = buf[11];
  buf[11] = '.';

  /* Create new volume label */
  fd = _creat( buf, FA_LABEL );
  if ( fd < 0 ) return -1;
  close( fd );

  return 0;
}
