/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdlib.h>
#include <direct.h>
#include <ctype.h>


/***
 *
 *  Function   :    setcwd
 *
 *  Topics     :    change to specified directory accross disks
 *
 *  Parameters :    in    char *dir    input directory name
 *
 *  Return code:    0      OK
 *                  other  Invalid syntax, drive or path
 ***/




int setcwd( const char *dir )

{ char drive[_MAX_DRIVE], buffer[_MAX_PATH];
  int currentdisk = _getdrive();

  _splitpath( dir, drive, buffer, buffer, buffer );

  if ( *drive ) { int disk = toupper(*drive) - 'A' + 1;
                  _chdrive( disk );
                  if ( disk != _getdrive() )
                     { _chdrive( currentdisk );
                       return -1;
                     }
                }

  if ( chdir(dir) ) { _chdrive( currentdisk );
                      return -1;
                    }

  return 0;
}
