/********************************************************/
/*							*/
/*	ro_var.c	Global variables for ro		*/
/*							*/
/*	ro version 1.10					*/
/*							*/
/*	Portions copyright (c) 1989 by Ted A. Campbell	*/
/*		Bywater Software			*/
/*		P. O. Box 4023				*/
/*		Duke Station				*/
/*		Durham, NC  27706			*/
/*							*/
/*	Contains portions of ROFF4, Version 1.60	*/
/*      (c) 1983, 4 by Ernest E. Bergmann               */
/*		Physics, Building #16			*/
/*		Lehigh University			*/
/*		Bethlehem, Pa. 18015			*/
/*							*/
/*	Contains portions of ROFF4, Version 1.61	*/
/*      (c) 1985 by Konrad Kwok                         */
/*		20 3rd Street, Section M		*/
/*		Fariview Park,				*/
/*		Hong Kong				*/
/*							*/
/*	ro and its predecessor ROFF4 are based on 	*/
/*	the ROFF text processor described in Kernigan	*/
/*	and Plauger's now-classic text <Software Tools> */
/*							*/
/* Permission is hereby granted for all commercial and	*/
/* non-commercial reproduction and distribution of this */
/* material provided this notice is included.		*/
/*							*/
/********************************************************/

/************* INCLUDE FILES ****************************/

#include "ro.h"

/****** GLOBAL VARIABLES ********************************/

FILE 	*_dobuf, *instream;	/* i/o buffer used for direction  */
#ifdef	DEBUG
int 	ro_debug;		/* Boolean:  debug mode on/off */
#endif
int	ro_verbose;		/* Boolean:  verbose mode on/off */
int 	ro_pagestop;
int 	ro_adjust;
int 	ro_useff;
int 	ro_firstpage, ro_lastpage;	/* for selectively printing output*/
int 	ro_suppress;		/* if true,no output is passed by putchar()*/
int 	ro_tival;      /* temporary indent -> default  0 */
int 	ro_ceval;      /* set equal to number of lines to be centered  */
int 	ro_spval;      /* blank lines to be spaced down */
int 	ro_curpag;     /* current output page number; init = 0 */
int 	ro_newpag;     /* next output page number; init = 1 */
int 	ro_vlineno;    /* virtual (intended) line advances on page,
                        see vadv()*/
int 	ro_vflineno;   /* + line fraction */
int 	ro_plineno;    /* printer's actual line advances on page,
                        see padv()*/
int 	ro_pflineno;   /* + line fraction */
int 	ro_bottom;     /* end of text area in lines;start of M3+M4 */
int 	ro_sentence;   /* Nov 20*/
int	ro_poval;	/* page offset */

/***	Stack variables

	The following variables are assigned to a stack and when 
	a new value is assigned, it is "pushed" onto the stack, 
	and when read, "popped" off.  The stack is read from 
	the bottom.  						***/

int 	ro_fill[STKSIZ];       /* set to YES or NO  */
int 	ro_lsval[STKSIZ];      /* line spacing value -> default will be 1  */
int 	ro_inval[STKSIZ];      /* left indent -> default  0  */
int 	ro_rmval[STKSIZ];      /* right margin -> default  PAGEWIDTH  */
int 	ro_tcval[STKSIZ];      /* translation flag char  */
int 	ro_plval[STKSIZ];      /* page length in lines  */
int 	ro_m1val[STKSIZ];      /* margin before& including header in lines */
int 	ro_m2val[STKSIZ];      /* margin after header in lines */
int 	ro_m3val[STKSIZ];      /* margin after last text line in lines */
int 	ro_m4val[STKSIZ];      /* bottom margin, including footer in lines */
int 	ro_scval[STKSIZ];      /* space character  */
int 	ro_tabsiz[STKSIZ];     /* spacing of tabstops  */
int 	ro_cfval[STKSIZ];      /* Dec 4:control flag character value  */
int 	ro_icval[STKSIZ];      /* insert character */

char 	ro_curline[ LSZ ];       /*input line buffer, Nov 26 */
char 	ro_ehead[ LSZ ], ro_eh2[ LSZ ], ro_eh3[ LSZ ];    /* even header title  */
char 	ro_ohead[ LSZ ], ro_oh2[ LSZ ], ro_oh3[ LSZ ];    /* odd header title  */
char 	ro_efoot[ LSZ ], ro_ef2[ LSZ ], ro_ef3[ LSZ ];    /* even footer title  */
char 	ro_ofoot[ LSZ ], ro_of2[ LSZ ], ro_of3[ LSZ ];    /* even footer title  */

char 	tbuf[ TBUFSIZE ];	/* a temporary buffer */
int 	ro_dir;        /* for "spreading" of lines     */
int 	ro_outwrds;    /* no. words in ro_outbuf; init = 0  */
char 	ro_outbuf[ LSZ ];     /*lines to be filled collected here  */
int 	ro_outw;       /*current display width of ro_outbuf */
int 	ro_outpos;     /* =strlen(ro_outbuf)  */
int 	ro_wtop, ro_ltop, ro_outtop;   /*zero|negative;levels of subscripts */
int 	ro_wbot, ro_lbot, ro_outbot;   /*zero|positive;levels of subscripts */
int 	ro_oldln;              /*position of previous main line */
int 	ro_oldbot;             /*ro_outbot for previous line;reset
                        each page */
int 	ro_frq, ro_frval;  /* fractional line?, what fraction size */
char 	*ro_frstring; /* ^ to code for fractional spacing */
char 	*ro_whstring; /* ^ to code for whole line spacing */
char 	*ro_cptr[128-' '];    /*pointer table for print control */
char 	*ro_tptr[128-' '];    /*pointer table for translation strings
                          for char; initialize to null  */

struct 	divfd *dlink;	/* points to head of diversion list  */
struct 	divfd *rlink;	/* points to head of register variable list  */
struct 	divfd *slink;	/* points to head of linked string list  */
struct 	divfd *mlink;	/* points to head of linked macro list  */

/*following added for buffered and formatted output:   */

char 	ro_out2buf[LSZ];      /*for line to be output in fancy fmt */
int 	ro_bpos, ro_cp, ro_pp;         /*buffer,column,printer positions */
char 	ro_xbuf[LSZ];         /*strikout buffer */
int 	ro_xf, ro_xcol;            /* " flag and column  */
char 	ro_ubuf[LSZ];         /*underline buffer */
int 	ro_uf, ro_ucol;            /* " flag and column  */
int 	ro_first;              /*flag for first pass */
char 	ro_dbuf[LSZ];         /*double strike buffer */
int 	ro_dpos;
int 	ro_ocnt;
int 	ro_mcnt;
int 	ro_blkcnt;

int 	ro_newxf, ro_newuf, ro_newmcnt; /* 3rd Mar,85 ; Conrad Kwok  */
char 	ro_lastch;    /* 5th Mar,85  ;  Conrad Kwok  */

char 	ro_backbuf[BACKSIZE];                 /* Backup buffer  */
int 	ro_binp;                               /* Position in above;init to 0  */
char 	ro_keybd;             /*boolean & prompt for keyboard input */
char 	ro_kline[MAXLINE];    /*keyboard line input buffer */
char 	*ro_kptr;             /*pointer for above */

int     	ro_fptr;
FILE 	*ro_fstack[FMAX];
int	ro_tflag;/*added for start(), complete() */
int 	ro_xf2, ro_uf2, ro_mcnt2;

/******** END OF FILE ***********************************/


