/***************************************************************

	sfsm.h          General Header File for
			Space Flight Simulator, 
			Main Menu and Orbital Modeling Module

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

/***    Include Files */

#include "bw.h"         /* header for generic Bywater handlers */
#include "as.h"         /* header for astronomy routines */
#include "gr.h"         /* header for graphics routines */
#include "dr.h"         /* header for directory routines */
#include "ui.h"         /* header for user interface routines */
#include "sfs.h"        /* header for sfs specific information */

/***    Program-specific definitions */

#define MAX_ENTRIES     64
#define TITLE_SIZE      64

/***************************************************************

	language-specific definitions

	English is taken as a default, and if SFSMNAME
	has not been defined, the English definitions will be
	utilized. To translate into other languages, we suggest
	that the following section be copied, a language name
	defined as one, and then each of the definitions rendered
	into the language. Example:

	;#define        LATIN   1
	;
	;
	;#if    LATIN
	;#define        SFSMNAME        " Pars Prima "
	;......etc.
	;#endif

	SFSMNAME will then be defined, and the English language
	tags will not be called.

***************************************************************/

#ifndef SFSMNAME
#define SFSMNAME        " Main Module "
#define SFSM_PAX        "VENIMVS IN PACE PRO OMNIBVS"
#define SFSM_CPRT       "Copyright (c) 1991, Ted A. Campbell"
#define SFSM_BWS        "Bywater Software"
#define SFSM_PEBL       "[Perspective Window Blocked]"
#define MM_SETPROGFILE  " Set SFS Program File"
#define MM_OM           " Orbital Modeling "
#define MM_OS           " Orbital Simulation "
#define MM_EXIT         " Exit from SFS "
#define SFSERR_GRINIT   "ERROR: Failed to initialize graphics system.\n"
#define MEMERR_DS       "Cannot allocate memory for directory structure %d \n"
#define MEMERR_TA       "Cannot allocate memory for title array %d \n"
#define UNTPROG         "(As yet untitled)"
#define STAT_TITLE      "STATUS"
#define SFSM_CPFI       "The current program file is:    %s; %s "
#define SFSM_CPFX       "Current Program File "
#define MM_TTL          " Main Menu "
#define SFSM_SPF        "Select SFS Program File"
#define MEMERR_ERR      "Cannot allocate memory for error message.\n"
#define ERR_PROMPT      "ERROR:  %s; Do you want to continue? "
#define ERRP_NO         "N - ABORT"
#define ERRP_YES        "Y - Continue"
#define ERR_MATH        "Mathematics error, %s"
#define OM_TITLE        "Orbital Modeling Menu"
#define SOP_TITLE       "Set Orbital Parameters"
#define AP_TITLE        "Additional Parameters"
#define OM_SPT          " Set program title [%s] "
#define OM_SON          " Set current orbit Number [%d] "
#define OM_SOP          " Set orbital parameters"
#define OM_SIP          " Set insertion parameter [%ld seconds] "
#define OM_SSP          " Set system parameters"
#define OM_VCO          " View current orbit"
#define OM_EXIT         " Exit from modeling"
#define OM_TTL          "Orbital Modeling Menu"
#define SPT_TITLE       "Set Program Title"
#define SPT_LEGEND      "Please enter a new title for the program or RETURN to keep the old one."
#define SPT_PROMPT      "Program Title:  "
#define SON_TITLE       "Set Current Orbit Number"
#define SON_LEGEND      "Enter an Orbit number between 1 and %d"
#define SON_PROMPT      "Number of Orbit:   "
#define SIP_TITLE       "Set Insertion Point "
#define SIP_LEGEND      "The insertion point is the moment in the orbit when insertion occurs.  Enter the insertion point in seconds."
#define SIP_PROMPT      "Insertion:   "
#define OM_SF           "Please indicate whether you want to save the parameters you have entered.  Enter Y or N"
#define SF_TITLE        "Set Filename to Save Parameters"
#define SF_LEGEND       "Please enter a filename for the new parameters to be saved, or enter <RETURN> to use the current name (old contents will be destroyed)."
#define SF_PROMPT       "Filename:  "
#define MM_MEMERR       "Cannot allocate memory for Modeling Menu "
#define OPM_MEMERR      "Cannot allocate memory for Orbital Parameters Menu "
#define APM_MEMERR      "Cannot allocate memory for Auxiliary Parameters Menu "
#define SPM_MEMERR      "Cannot allocate memory for System Parameters Menu "
#define SSP_TF          " Time Factor [%ld x real time]"
#define SSP_UI          " Screen Update Interval [%ld seconds]"
#define SSP_TPL         " Trig Precision Level [%d]"
#define SSP_EXIT        " Exit to Main Orbital Modeling Menu"
#define SSP_TITLE       "Set System Parameters"
#define SOP_SOF         " Set orbital focus [%s] "
#define SOP_SN          " Name of Spacecraft/Orbit [%s]"
#define SOP_SDF         " Surface Datafile [%s]"
#define SOP_PRI         " Periapsis [%.2lf km]"
#define SOP_APO         " Apoapsis [%.2lf km]"
#define SOP_INC         " Inclination [%.2lf deg]"
#define SOP_ARP         " Argument of the Periapsis [%.2lf deg]"
#define SOP_LAN         " Longitude of Asc. Node [%.2lf deg]"
#define SOP_EXIT        " Exit to Main Orbital Modeling Menu"
#define SOP_TITLE2      "Set Parameters for Orbit %d"
#define SOF_TITLE       "Select SFS Focal Data File"
#define SN_TITLE        "Set Orbit/Spacecraft Name for Orbit %d"
#define SN_PROMPT       "Name of Orbit/Spacecraft:   "
#define SN_LEGEND       "Enter a name for the orbit or the spacecraft."
#define SDF_TITLE       "Select Surface Data File"
#define PRI_TITLE       "Set Periapsis for Orbit %d"
#define PRI_LEGEND      "The periapsis is the lowest point in an orbit.  Enter the periapsis in kilometers (must be less than %.1lf km). "
#define PRI_PROMPT      "Periapsis:   "
#define APO_TITLE       "Set Apoapsis for Orbit %d"
#define APO_LEGEND      "The apoapsis is the highest point in an orbit.  Enter the apoapsis in kilometers (must be greater than %.1lf km). "
#define APO_PROMPT      "Apoapsis:  "
#define INC_TITLE       "Set Inclination for Orbit %d"
#define INC_LEGEND      "The inclination describes the angle at which the orbit is inclined with relation to the equator of the orbital focus.  Enter the inclination in degrees between %.1lf and %.1lf. "
#define INC_PROMPT      "Inclination:   "
#define ARP_TITLE       "Set Argument of the Periapsis for Orbit %d"
#define ARP_LEGEND      "The argument of the periapsis describes the point in the orbit at which periapsis occurs, measured from the point of the ascending node.  Enter the argument of the periapsis in degrees between %.1lf and %.1lf."
#define ARP_PROMPT      "Argument of Periapsis:  "
#define LAN_TITLE       "Set the Longitude of the Ascending Node for Orbit %d"
#define LAN_LEGEND      "The longitude of the ascending node describes the point in the first orbit at which the spacecraft crosses the equator heading northward.  Enter the longitude of the ascending node in degrees between %.1lf and %.1lf."
#define LAN_PROMPT      "Longitude of Ascending Node:  "
#define AP_MAS          " Mass of the Orbital Focus [%.2le gr]"
#define AP_RAD          " Radius of the Orbital Focus [%.0lf km]"
#define AP_SID          " Sidereal Period [%.0lf seconds]"
#define AP_SMI          " Semiminor Axis [%.2lf km]"
#define AP_ECC          " Eccentricity [%.6lf]"
#define AP_PER          " Orbital Period [%.2lf seconds; %.2lf days]"
#define AP_TITLE2       "Additional Parameters for Orbit %d"
#define GETYN_NO        " NO "
#define GETYN_YES       " YES "
#define SPW_MEMERR      "Cannot allocate memory for set parameters window "
#define MES_MM          "Main Menu"
#define MES_OM          "Orbital Modeling Menu"
#define MES_SP          "Set Parameters Menu"
#define MES_SSP         "Set System Parameters Menu"
#endif

extern  double  get_double();
extern  long    get_long();

extern  char    init_buffer[ 128 ]; /* Buffer for initialization
					of focal data			*/
extern  char    sfs_tbuf[ 512 ];

extern  int     sfs_curorbit;
extern  long    sfs_insertion;
extern  long    sfs_inc;      	
extern	long	sfs_tfactor;	/* time factor			*/
extern  char    sfs_prname[ 128 ];
extern	int	sfs_go;
extern  double  sfs_size;       /* size factor for particular screen    */
extern	double 	sin_table[ 91 ];

extern  int  	display;
extern	int  	_xy_array[ 20 ];
extern	int  	work_in[ 21 ];
extern  int    work_out[ 57 ];
extern  char    sfs_program[ 36  ];
extern  struct  uiwindow *set_window;
extern  struct  menu_box w1, w2, w3, w4;
extern	int      sp_x1, sp_y1, sp_x2, sp_y2;
extern struct dir_ent *d_entries[ MAX_ENTRIES ];
extern char *d_titles[ MAX_ENTRIES ];


/***    Colors */

extern	int	cl_mback;		/* Main background color	*/
extern	int	cl_mfore;		/* Main foreground color	*/
extern	int	cl_marker;		/* Color for prompt markers	*/
extern	int	cl_grid;		/* Color for planetary grid	*/
extern	int	cl_surface;		/* Color for planetary surface	*/
extern	int	cl_orbits[ 6 ];		/* Colors for different orbits	*/

extern struct  uiwindow *main_window;          /* structure for main window    */
extern struct  uiwindow *logo_window;

extern int     stat_y1;                        /* line for status display      */
extern int     stat_y2;                        /* top of status display        */
extern int     stat_x1;                        /* column for status display    */
extern int     stat_x2;                        /* max col for status display   */

