;
; *** Listing 14-9 ***
;
; Searches for the first appearance of a character, in any
; case, in a byte-sized array by using JZ, DEC REG8, and
; JNZ.
;
	jmp	Skip
;
ByteArray	label	byte
	db	'Array Containing Both Upper and Lowercase'
	db	' Characters And Blanks'
ARRAY_LENGTH	equ	($-ByteArray)
;
; Finds the first occurrence of the specified character, in
; any case, in the specified byte-sized array.
;
; Input:
;	AL = character for which to perform a
;		case-insensitive search
;	CL = array length (0 means 256 long)
;	DS:SI = array to search
;
; Output:
;	SI = pointer to first case-insensitive match, or 0
;		if no match is found
;
; Registers altered: AX, CL, SI
;
; Direction flag cleared
;
; Note: Does not handle arrays that are longer than 256
;	bytes or cross segment boundaries.
;
; Note: Do not pass an array that starts at offset 0 (SI=0),
;	since a match on the first byte and failure to find
;	the byte would be indistinguishable.
;
CaseInsensitiveSearch:
	cld
	cmp	al,'a'
	jb	CaseInsensitiveSearchBegin
	cmp	al,'z'
	ja	CaseInsensitiveSearchBegin
	and	al,not 20h	;make sure the search byte
				; is uppercase
CaseInsensitiveSearchBegin:
	mov	 ah,al		;put the search byte in AH
				; so we can use AL to hold
				; the bytes we're checking
CaseInsensitiveSearchLoop:
	lodsb			;get the next byte from the
				; array being searched
	cmp	al,'a'
	jb	CaseInsensitiveSearchIsUpper
	cmp	al,'z'
	ja	CaseInsensitiveSearchIsUpper
	and	al,not 20h	;make sure the array byte is
				; uppercase
CaseInsensitiveSearchIsUpper:
	cmp	al,ah		;do we have a
				; case-insensitive match?
	jz	CaseInsensitiveSearchMatchFound	;yes
	dec	cl		;count down bytes remaining
				; in array being searched
	jnz	CaseInsensitiveSearchLoop
				;check the next byte, if any
	sub	si,si		;no match found
	ret
CaseInsensitiveSearchMatchFound:
	dec	si		;point back to the matching
				; array byte
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'K'		;character to search for
	mov	si,offset ByteArray ;array to search
	mov	cx,ARRAY_LENGTH	;# of bytes to search
				; through
	call	CaseInsensitiveSearch
				;perform a case-insensitive
				; search for 'K'
	call	ZTimerOff
