;
; *** Listing 7-15 ***
;
; Performs very fast bit-doubling of a byte in AL to a
; word in AX by using a look-up table.
; This approach avoids both branching and the severe
; instruction-fetching penalty of the shift-based approach.
;
; Macro to double each bit in a byte.
;
; Input:
;	AL = byte to bit-double
;
; Output:
;	AX = bit-doubled word
;
; Registers altered: AX, BX
;
DOUBLE_BYTE	macro
	mov	bl,al	;move the byte to look up to BL,
	sub	bh,bh	; make a word out of the value,
	shl	bx,1	; and double the value so we can
			; use it as a pointer into the
			; table of word-sized doubled byte
			; values
	mov	ax,[DoubledByteTable+bx]
			;look up the doubled byte value
	endm
;
	jmp	Skip
DOUBLED_VALUE=0
DoubledByteTable	label	word
	dw	00000h,00003h,0000ch,0000fh,00030h,00033h,0003ch,0003fh
	dw	000c0h,000c3h,000cch,000cfh,000f0h,000f3h,000fch,000ffh
	dw	00300h,00303h,0030ch,0030fh,00330h,00333h,0033ch,0033fh
	dw	003c0h,003c3h,003cch,003cfh,003f0h,003f3h,003fch,003ffh
	dw	00c00h,00c03h,00c0ch,00c0fh,00c30h,00c33h,00c3ch,00c3fh
	dw	00cc0h,00cc3h,00ccch,00ccfh,00cf0h,00cf3h,00cfch,00cffh
	dw	00f00h,00f03h,00f0ch,00f0fh,00f30h,00f33h,00f3ch,00f3fh
	dw	00fc0h,00fc3h,00fcch,00fcfh,00ff0h,00ff3h,00ffch,00fffh
;
	dw	03000h,03003h,0300ch,0300fh,03030h,03033h,0303ch,0303fh
	dw	030c0h,030c3h,030cch,030cfh,030f0h,030f3h,030fch,030ffh
	dw	03300h,03303h,0330ch,0330fh,03330h,03333h,0333ch,0333fh
	dw	033c0h,033c3h,033cch,033cfh,033f0h,033f3h,033fch,033ffh
	dw	03c00h,03c03h,03c0ch,03c0fh,03c30h,03c33h,03c3ch,03c3fh
	dw	03cc0h,03cc3h,03ccch,03ccfh,03cf0h,03cf3h,03cfch,03cffh
	dw	03f00h,03f03h,03f0ch,03f0fh,03f30h,03f33h,03f3ch,03f3fh
	dw	03fc0h,03fc3h,03fcch,03fcfh,03ff0h,03ff3h,03ffch,03fffh
;
	dw	0c000h,0c003h,0c00ch,0c00fh,0c030h,0c033h,0c03ch,0c03fh
	dw	0c0c0h,0c0c3h,0c0cch,0c0cfh,0c0f0h,0c0f3h,0c0fch,0c0ffh
	dw	0c300h,0c303h,0c30ch,0c30fh,0c330h,0c333h,0c33ch,0c33fh
	dw	0c3c0h,0c3c3h,0c3cch,0c3cfh,0c3f0h,0c3f3h,0c3fch,0c3ffh
	dw	0cc00h,0cc03h,0cc0ch,0cc0fh,0cc30h,0cc33h,0cc3ch,0cc3fh
	dw	0ccc0h,0ccc3h,0cccch,0cccfh,0ccf0h,0ccf3h,0ccfch,0ccffh
	dw	0cf00h,0cf03h,0cf0ch,0cf0fh,0cf30h,0cf33h,0cf3ch,0cf3fh
	dw	0cfc0h,0cfc3h,0cfcch,0cfcfh,0cff0h,0cff3h,0cffch,0cfffh
;
	dw	0f000h,0f003h,0f00ch,0f00fh,0f030h,0f033h,0f03ch,0f03fh
	dw	0f0c0h,0f0c3h,0f0cch,0f0cfh,0f0f0h,0f0f3h,0f0fch,0f0ffh
	dw	0f300h,0f303h,0f30ch,0f30fh,0f330h,0f333h,0f33ch,0f33fh
	dw	0f3c0h,0f3c3h,0f3cch,0f3cfh,0f3f0h,0f3f3h,0f3fch,0f3ffh
	dw	0fc00h,0fc03h,0fc0ch,0fc0fh,0fc30h,0fc33h,0fc3ch,0fc3fh
	dw	0fcc0h,0fcc3h,0fccch,0fccfh,0fcf0h,0fcf3h,0fcfch,0fcffh
	dw	0ff00h,0ff03h,0ff0ch,0ff0fh,0ff30h,0ff33h,0ff3ch,0ff3fh
	dw	0ffc0h,0ffc3h,0ffcch,0ffcfh,0fff0h,0fff3h,0fffch,0ffffh
;
Skip:
	call	ZTimerOn
BYTE_TO_DOUBLE=0
	rept	100
	mov	al,BYTE_TO_DOUBLE
	DOUBLE_BYTE
BYTE_TO_DOUBLE=BYTE_TO_DOUBLE+1
	endm
	call	ZTimerOff
