; MOVESUB - move (copy) memory routine for interpretive and compiled BASIC
; Copyright 1983 Data Base Decisions
; CALL MOVESUB(FRSEG%,FRLOC%,TOSEG%,TOLOC%,BYTES%)
; FRSEG% is the segment (DEF SEG) of the source
; FRLOC% is the location of the source within FROMSEG%
; TOSEG% is the segment (DEF SEG) of the destination
; TOLOC% is the location of the destination within TOSEG%
; BYTES% is the number of bytes to be copied - must be from 1 to 65535

; Note: this routine cannot handle an overlapping copy where the target
; address is higher than the source address. For example, a copy from
; 1000:0 to 1000:100 with a length of 200 would copy 1000:0 - 1000:FF
; correctly, but would duplicate 1000:100 - 1000:1FF, since it would
; be clobbered by the first part of the copy.

cseg	segment para public 'code'
public	movesub
movesub proc far

	assume cs:cseg,ds:nothing,ss:nothing,es:nothing
	push bp
	mov bp,sp
	push ds 		; save ds
	push es 		; and es
	mov si,[bp+6]		; get BYTES%
	mov cx,[si]
	mov si,[bp+8]		; get TOLOC%
	mov di,[si]
	mov si,[bp+10]		; get TOSEG%
	mov ax,[si]
	mov es,ax
	mov si,[bp+12]		; get FRLOC%
	mov bx,[si]		; hold in bx
	mov si,[bp+14]		; get FRSEG%
	mov ax,[si]
	mov ds,ax
	mov si,bx		; all set
	repnz movsb		; move it
	pop es			; restore registers
	pop ds
	pop bp			; return to caller
	ret 10

movesub endp
cseg	ends
	end
          