#define HEADER "C++ Problem 3.2 by Rick Conn using Borland C++"

#include <stdio.h>
#include <string.h>  // for strcpy()

const max_string_length = 100;

class string {
  char data[max_string_length];
  static int number_of_strings;
public:
  string (char *);
  static int count (void);
  void print (void);
};

int string::number_of_strings = 0;

string::string(char *new_string) {
  strcpy(data, new_string);
  string::number_of_strings++;
}

int string::count(void) {
  return number_of_strings;
}

void string::print(void) {
  printf("String = \"%s\"\n", data);
}

void main(void)
{
  printf("%s\n", HEADER);

  string s1("This is a test");
  string s2("This is only a test");
  string s3("This is fun");
  printf("The count is %d\n", string::count());

  string s4("Another string");
  string s5("Yet another string");
  printf("The count is %d\n", string::count());

  s1.print();
  s2.print();
  s3.print();
  s4.print();
  s5.print();
}
