#define HEADER "C++ Problem 4.5 by Rick Conn using Borland C++"

#include <stdio.h>

class base {
protected:
  char *msg;
public:
  base(char *);
  ~base();
  void print(void);
};

class derived1 : base {
public:
  derived1(char *);
  ~derived1();
};

class derived2 : derived1 {
public:
  derived2(char *);
  ~derived2();
};

base::base (char *m) {
  msg = m;
  printf("Base constructor called with message %s\n", msg);
}

base::~base() {
  printf("  Base destructor called with message %s\n", msg);
}

void base::print(void) {
  printf(" with message %s\n", msg);
}

derived1::derived1 (char *m) : base(m) {
  printf("  Derived1 constructor called");
  print();
}

derived1::~derived1() {
  printf("  Derived1 destructor called");
  print();
}

derived2::derived2 (char *m) : derived1(m) {
  printf("  Derived2 constructor called\n");
}

derived2::~derived2() {
  printf("Derived2 destructor called\n");
}

void main(void)
{
  printf("%s\n", HEADER);

  derived2 x ("X");
  {
    derived2 y ("Y");
  }
  derived2 z ("Z");
}
