-- Problem 2.2
-- by Rick Conn
with Text_IO;
procedure Main is

  type SPEED is new FLOAT range 0.0 .. 1_000_000.0;      -- MPH
  type TIME is new FLOAT range 0.0 .. 24.0;              -- hours
  type DISTANCE is new FLOAT range 0.0 .. 24_000_000.0;  -- miles

  Current_Speed     : SPEED;
  Elapsed_Time      : TIME;
  Computed_Distance : DISTANCE;

  package Float_IO is new Text_IO.Float_IO (FLOAT);

  function "*" (S : in SPEED;
                T : in TIME)
      return DISTANCE is
  begin
    return DISTANCE (FLOAT(S) * FLOAT(T));
  end "*";

begin -- Main

  Text_IO.Put_Line ("Speed      Time  Distance");
  for S in 0 .. 5 loop
    Current_Speed := SPEED (FLOAT(S) * 200_000.0);

    for T in 0 .. 3 loop
      Elapsed_Time := TIME (FLOAT(T) * 8.0);

      Computed_Distance := Current_Speed * Elapsed_Time;

      Float_IO.Put (FLOAT(Current_Speed), 7, 1, 0);
      Text_IO.Put("  ");
      Float_IO.Put (FLOAT(Elapsed_Time), 2, 1, 0);
      Text_IO.Put("  ");
      Float_IO.Put (FLOAT(Computed_Distance), 8, 1, 0);
      Text_IO.New_Line;

    end loop;
  end loop;

end Main;
