-- Problem 2.3
-- by Rick Conn
with Text_IO;
procedure Main is

  type SQUARE is (EMPTY, CROSS, ZERO);
  type ROW is (ROW_1, ROW_2, ROW_3);
  type COL is (COL_1, COL_2, COL_3);
  type TIC_TAC_TOE_BOARD is array (ROW, COL) of SQUARE;

  TTT_1 : TIC_TAC_TOE_BOARD := (ROW_1 => (EMPTY, CROSS, CROSS),
                                ROW_2 => (ZERO, EMPTY, EMPTY),
                                ROW_3 => (ZERO, ZERO, CROSS));

  TTT_2 : TIC_TAC_TOE_BOARD := (ROW_1 => (CROSS, ZERO, CROSS),
                                ROW_2 => (ZERO, ZERO, EMPTY),
                                ROW_3 => (ZERO, CROSS, CROSS));

  procedure Display (TTT : in TIC_TAC_TOE_BOARD) is
    package Square_IO is new Text_IO.Enumeration_IO (SQUARE);
  begin -- Display
    Text_IO.Put_Line ("TTT Board:");
    for R in ROW loop
      Text_IO.Put ("  ");
      for C in COL loop
        Square_IO.Put (TTT_1 (R, C), 6);
      end loop;
      Text_IO.New_Line;
    end loop;
  end Display;

begin -- Main

  Display (TTT_1);
  Display (TTT_2);

end Main;
