-- Problem 4.5
-- by Rick Conn
with Text_IO;
procedure Main is

  DIVIDE_BY_ZERO : exception;

  type INTARRAY is array (INTEGER range <>) of INTEGER;

  I1 : constant INTARRAY := (2, 3, 4, 5, 6, 7);
  J1 : constant INTARRAY := (2, 0, 1, 0);
  K  : INTEGER;

  package Int_IO is new Text_IO.Integer_IO (INTEGER);

  function "/" (Left, Right : in INTEGER) return INTEGER is
  begin
    if Right = 0 then
      raise DIVIDE_BY_ZERO;
    end if;
    return Standard."/" (Left, Right);
  end "/";

  procedure Print_ALL (I1_Index, J1_Index, K : in INTEGER) is
  begin
    Int_IO.Put (I1(I1_Index), 2);
    Text_IO.Put ("/");
    Int_IO.Put (J1(J1_Index), 2);
    Text_IO.Put (" = ");
    Int_IO.Put (K, 2);
    Text_IO.New_Line;
  end Print_All;

begin -- main

  for J in J1'RANGE loop
    for I in I1'RANGE loop
      begin
        K := I1(I) / J1(J);
        Print_All (I, J, K);
      exception
        when DIVIDE_BY_ZERO =>
          Text_IO.Put ("Division by Zero: ");
          Int_IO.Put (I1(I), 2);
          Text_IO.Put (" / ");
          Int_IO.Put (J1(J), 2);
          Text_IO.New_Line;
      end;
    end loop;
  end loop;

end Main;
