-- Problem 4.3
-- by Rick Conn
generic
  type ELEMENT is private;
  type INDEX is (<>);
  type VECTOR is array (INDEX range <>) of ELEMENT;
  with function "<" (Left, Right : in ELEMENT) return BOOLEAN;
procedure Bubble_Sort (Item : in out VECTOR);

procedure Bubble_Sort (Item : in out VECTOR) is
  Temp : ELEMENT;
begin
  for I in Item'RANGE loop
    for J in INDEX'SUCC(I) .. Item'LAST loop
      if Item(J) < Item(I) then
        Temp    := Item(I);
        Item(I) := Item(J);
        Item(J) := Temp;
      end if;
    end loop;
  end loop;
end Bubble_Sort;

with Text_IO;
with Bubble_Sort;
procedure Main is

  type REC is record
    N1 : INTEGER;
    N2 : INTEGER;
  end record;

  type COLOR is (RED, GREEN, BLUE, YELLOW, VIOLET, GRAY, WHITE);

  type RECARRAY is array (COLOR range <>) of REC;
  type INTARRAY is array (NATURAL range <>) of INTEGER;
  type FLTARRAY is array (NATURAL range <>) of FLOAT;

  R1 : RECARRAY(RED .. YELLOW) := ((5, 2), (2, 2), (10, 10), (3, 3));
  I1 : INTARRAY(5..9) := (5, 2, 6, 1, 3);
  F1 : FLTARRAY(11..12) := (2.2, 1.1);

  function "<" (Left, Right : in REC) return BOOLEAN is
  begin
    return Left.N1 + Left.N2 < Right.N1 + Right.N2;
  end "<";

  procedure Int_Sort is new Bubble_Sort
    (ELEMENT => INTEGER,
     INDEX   => NATURAL,
     VECTOR  => INTARRAY,
     "<"     => Standard."<");

  procedure Float_Sort is new Bubble_Sort
    (ELEMENT => FLOAT,
     INDEX   => NATURAL,
     VECTOR  => FLTARRAY,
     "<"     => Standard."<");

  procedure Rec_Sort is new Bubble_Sort
    (ELEMENT => REC,
     INDEX   => COLOR,
     VECTOR  => RECARRAY,
     "<"     => Main."<");

  package Int_IO is new Text_IO.Integer_IO (INTEGER);
  package Flt_IO is new Text_IO.Float_IO (FLOAT);

  procedure Print_All is

    procedure Rec_Print (R : in REC) is
    begin
      Text_IO.Put("  ("); Int_IO.Put (R.N1, 3); Text_IO.Put(", ");
      Int_IO.Put (R.N2, 3); Text_IO.Put (')');
    end Rec_Print;

  begin
    Text_IO.Put ("Records: ");
    for I in R1'RANGE loop
      Rec_Print (R1(I));
    end loop;
    Text_IO.New_Line;
    Text_IO.Put ("Integers: ");
    for I in I1'RANGE loop
      Int_IO.Put (I1(I), 3);
    end loop;
    Text_IO.New_Line;
    Text_IO.Put ("Floats: ");
    for I in F1'RANGE loop
      Flt_IO.Put (F1(I), 3, 1, 0);
    end loop;
    Text_IO.New_Line;
  end Print_All;

begin -- Main

  Print_All;
  Rec_Sort (R1);
  Int_Sort (I1);
  Float_Sort (F1);
  Print_All;

end Main;
