with TEXT_IO; use TEXT_IO;
procedure TRITEST is
   PASSED : BOOLEAN := TRUE;
   type TRIANGLE is (EQUILATERAL, ISOSCELES, SCALENE, NOT_A_TRIANGLE);
   function TRITYPE(LEN1, LEN2, LEN3 : in INTEGER) return TRIANGLE
                                                          is separate;
   procedure COMPARE(A, B, C: in INTEGER; RIGHT_ANSWER : in TRIANGLE)
                                                          is separate;
begin
   COMPARE( 3,  4,  5, SCALENE);
   COMPARE( 6,  3,  4, SCALENE);
   COMPARE( 4,  3,  6, SCALENE);
   COMPARE( 3,  3,  3, EQUILATERAL);
   COMPARE( 3,  3,  4, ISOSCELES);
   COMPARE( 3,  4,  3, ISOSCELES);
   COMPARE( 4,  3,  3, ISOSCELES);
   COMPARE( 7,  7,  4, ISOSCELES);
   COMPARE( 7,  4,  7, ISOSCELES);
   COMPARE( 4,  7,  7, ISOSCELES);
   COMPARE( 1,  1,  1, EQUILATERAL);
   COMPARE( 0,  4,  4, NOT_A_TRIANGLE);
   COMPARE( 4,  0,  4, NOT_A_TRIANGLE);
   COMPARE( 4,  4,  0, NOT_A_TRIANGLE);
   COMPARE( 0,  4,  3, NOT_A_TRIANGLE);
   COMPARE( 3,  0,  4, NOT_A_TRIANGLE);
   COMPARE( 4,  3,  0, NOT_A_TRIANGLE);
   COMPARE(-1,  4,  4, NOT_A_TRIANGLE);
   COMPARE( 4, -1,  4, NOT_A_TRIANGLE);
   COMPARE( 4,  4, -1, NOT_A_TRIANGLE);
   COMPARE(-1,  4,  3, NOT_A_TRIANGLE);
   COMPARE( 3, -1,  4, NOT_A_TRIANGLE);
   COMPARE( 4,  3, -1, NOT_A_TRIANGLE);
   COMPARE( 2,  4,  6, NOT_A_TRIANGLE);
   COMPARE( 1,  3,  2, NOT_A_TRIANGLE);
   COMPARE( 3,  1,  2, NOT_A_TRIANGLE);
   COMPARE( 1,  2,  4, NOT_A_TRIANGLE);
   COMPARE( 1,  4,  2, NOT_A_TRIANGLE);
   COMPARE( 4,  1,  2, NOT_A_TRIANGLE);
   COMPARE( 0,  0,  0, NOT_A_TRIANGLE);
   COMPARE( 0,  0,  4, NOT_A_TRIANGLE);
   COMPARE( 0,  4,  0, NOT_A_TRIANGLE);
   COMPARE( 4,  0,  0, NOT_A_TRIANGLE);
   COMPARE( 3,  3,  7, NOT_A_TRIANGLE);
   COMPARE( 3,  7,  3, NOT_A_TRIANGLE);
   COMPARE( 6,  3,  3, NOT_A_TRIANGLE);
   COMPARE(-3, -4, -5, NOT_A_TRIANGLE);
   if PASSED then
      PUT_LINE("Congratulations, you completed the assignment!");
   end if;
end TRITEST;

separate (TRITEST)
procedure COMPARE(A, B, C: in INTEGER; RIGHT_ANSWER : in TRIANGLE) is
   package INT_IO is new INTEGER_IO(INTEGER); use INT_IO;
   package TRI_IO is new ENUMERATION_IO(TRIANGLE); use TRI_IO;
   MY_ANSWER : TRIANGLE := TRITYPE(A, B, C);
begin
   if MY_ANSWER /= RIGHT_ANSWER then
      PUT("Sides:");
      PUT(A, WIDTH => 3);
      PUT(B, WIDTH => 3);
      PUT(C, WIDTH => 3);
      PUT("   My answer: ");
      PUT(MY_ANSWER, WIDTH => 14);
      PUT("   Right answer: ");
      PUT(RIGHT_ANSWER);
      NEW_LINE;
      PASSED := FALSE;
   end if;
end COMPARE;
