' ANSIVIEW.BAS by Duane Paulson  Version 2.01
' Simple utility to view text files containing ANSI screen control codes.

' For Microsoft BASIC Professional Developer's System, version 7.1.
' Sorry, some functions are not compatible with QuickBASIC.

' BASIC Professional Developer's System and QuickBASIC are trademarks of Microsoft Corporation.

' Compiler instructions:
'     8088 version:
'        BC /O /Ot /Fpa /C:1 ansiview.bas, aview.obj,;
'     80286 version:
'        BC /O /Ot /Fpa /C:1 /G2 ansiview.bas, aview286.obj,;

' Linker instructions:
'     LINK /NOE aview[286].obj+tscnionr.obj+smallerr.obj+nolpt.obj+nocom.obj+noedit.obj,aview[286].exe,,BCL71ANR.LIB,;

CONST Title$ = "ANSIVIEW Version 2.01 ANSI file viewer by Duane Paulson 02/26/91"
CONST CString$ = "Portions (C) 1982-1990 Microsoft Corporation. All rights reserved."

CONST MaxDelay% = 32268, MinDelay% = 499
CONST HiByte% = &H5, LoByte% = &HE0

DEFINT A-Z

Delay = 15000

OPEN "CONS:" FOR OUTPUT AS #2
PRINT #2,

FileName$ = COMMAND$
IF FileName$ = "" THEN GOTO Help

IF DIR$(FileName$) = "" THEN GOTO NotFound

OPEN FileName$ FOR BINARY AS #1 LEN = 32767

DO WHILE NOT EOF(1)
   a$ = INPUT$(1, 1)
   PRINT #2, a$;
   SELECT CASE UCASE$(INKEY$)
      CASE " "
         DO: LOOP WHILE INKEY$ = ""
      CASE CHR$(27)
         CLOSE #1
         GOTO Ender
      CASE "S"
         IF Delay < MaxDelay THEN Delay = Delay + 500 ELSE GOSUB Blip
      CASE "F"
         IF Delay > MinDelay THEN Delay = Delay - 500 ELSE GOSUB Blip
   END SELECT
   FOR a = 0 TO Delay: NEXT a
LOOP

CLOSE #1
PRINT #2, CHR$(7);
DO: LOOP WHILE INKEY$ = ""

GOTO Ender

NotFound:
   PRINT #2, CHR$(7); "File "; FileName$; " not found."
   PRINT #2,
   El = 1

Help:
   PRINT #2, "Syntax: aview[286] Filename"
   PRINT #2,
   PRINT #2, "<SPACEBAR> toggles scrolling on and off"
   PRINT #2, "<F> speeds up the scrolling"
   PRINT #2, "<S> slows down the scrolling"
   PRINT #2, "<ESC> exits the program"
   PRINT #2,

Ender:
   PRINT #2,
   PRINT #2, Title
   PRINT #2, CString
   PRINT #2,

END El

Blip:                            ' Local subroutine to produce a short
   OUT 67, 182                   ' tone on the speaker. Local subroutines
   OUT 66, LoByte                ' are much faster than SUBprocesses when
   OUT 66, HiByte                ' you just have a simple, short routine
   SpkrOn = INP(97) OR &H3       ' to handle.
   OUT 97, SpkrOn

   FOR a = 1 TO 15000: NEXT a

   SpkrOff = INP(97) AND &HFC
   OUT 97, SpkrOff
RETURN

