/*
   This file is a greatly pared down version of "active.c" for rnews.

    Read that file for more information.

*/

#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys\stat.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXDIR FILENAME_MAX
#endif

#include "active.h"
#include "lib.h"

currentfile();

extern char *E_newsdir;


struct grp *group_list = NULL;  /* List of all groups */


void check_alloc(p)
   void *p;
{
   if (p == NULL)
   {
      /* malloc failed.  Abandon ship */
      printf("Unable to get enough memory for the active file\n");
      exit(1);
   }
   return;

}

/* ------------------------------------------------------

   g e t _ a c t i v e

   This function opens <newsdir>/active and extracts all
   the information about the newsgroup we currently
   maintain

   ------------------------------------------------------ */

void get_active()
{

/* Open the active file and extract all the newsgroups and their
 * next number.
 *
 */

   char active_filename[MAXDIR];
   char buf[BUFSIZ];
   char grp_name_tmp[51];    /* Space to hold the
                              * group field being
                              * read in */
   char *t;
   FILE *g;
   struct grp *cur_grp;
   struct grp *prev_grp;
   int i;
   int j;

   mkfilename( active_filename, E_confdir, ACTIVE );

   g = fopen(active_filename, "r");
   if (g == NULL)
   {
      printerr(active_filename);

      mkfilename( active_filename, E_newsdir, ACTIVE );

      g = fopen(active_filename, "r");
      if (g == NULL)
      {
         printerr(active_filename);
         panic();
      }
   }

   prev_grp = NULL;

   group_list = (struct grp *) malloc(sizeof (struct grp));
   check_alloc(group_list);
   cur_grp = group_list;

   cur_grp->grp_next = NULL;
   cur_grp->grp_name = NULL;
   cur_grp->grp_low = 0;
   cur_grp->grp_high = 0;
   cur_grp->grp_can_post = ' ';

   while ((i = fscanf(g, "%s %ld %ld %1s\n", &grp_name_tmp[0],
                      &cur_grp->grp_high,
                      &cur_grp->grp_low,
                      &cur_grp->grp_can_post)) != EOF)
   {
      if (i != 4)
      {
         printmsg(0, "rnews: error reading %s", active_filename);
         exit(3);
      }

      j = strlen(grp_name_tmp) + 1;
      cur_grp->grp_name = malloc(j);
      check_alloc(cur_grp->grp_name);
      strcpy(cur_grp->grp_name, grp_name_tmp);

      cur_grp->grp_high++;   /* It is stored as one
                              * less than we want it */

      prev_grp = cur_grp;
      cur_grp = (struct grp *) malloc(sizeof (struct grp));
      check_alloc(cur_grp);
      prev_grp->grp_next = cur_grp;

      cur_grp->grp_next = NULL;
      cur_grp->grp_name = NULL;
      cur_grp->grp_low = 0;
      cur_grp->grp_high = 0;
      cur_grp->grp_can_post = ' ';

   }

   i = fclose(g);
   if (i != 0)
   {
      printmsg(0, "rnews: problem closing %s", active_filename);
   }

   if (prev_grp != NULL)
   {
      prev_grp->grp_next = NULL;
      free(cur_grp);
   }

   return;
}
