


                                                         SMAIL(8)



NAME
     smail, rmail - UUCP mailer with routing

SYNOPSIS
     smail [ options ] address ...
     rmail [ options ] address ...

DESCRIPTION
     The _s_m_a_i_l/_r_m_a_i_l program replaces /_b_i_n/_r_m_a_i_l(1) to become the
     UUCP mail transport mechanism.  They are links to the same
     executable.  _r_m_a_i_l receives mail from UUCP, _s_m_a_i_l introduces
     mail into UUCP.

     _s_m_a_i_l/_r_m_a_i_l can work with or without _s_e_n_d_m_a_i_l(8), or another
     intelligent mail system.  For hosts with just /_b_i_n/_m_a_i_l(1),
     _s_m_a_i_l/_r_m_a_i_l subsumes some of the functions of _s_e_n_d_m_a_i_l, and
     hands only local mail to /_b_i_n/_m_a_i_l. For hosts with _s_e_n_d_m_a_i_l,
     _s_m_a_i_l/_r_m_a_i_l can act as UUCP front and back ends to _s_e_n_d_m_a_i_l,
     allowing _s_e_n_d_m_a_i_l to process all mail through the host.  As
     distributed, 'bang' mail that is not bound for a local reci-
     pient will be passed directly to _u_u_x without calling _s_e_n_d_-
     _m_a_i_l.

     To varying degrees, _s_m_a_i_l/_r_m_a_i_l automatically routes the
     addresses it processes.  _s_m_a_i_l/_r_m_a_i_l most often routes
     domain style addresses (i.e. user@domain), producing a UUCP
     path (i.e. host!address) or a local address (i.e. user), but
     it can also reroute explicit UUCP paths.

OPTIONS
     -A   Print the resolved addresses.  Don't collect a message
          or invoke a mailer.

     -d   Be verbose and don't invoke other mailers.

     -v   Be verbose, but still invoke other mailers.

     -h _h_o_s_t_n_a_m_e
          Set hostname.  The default is configuration dependent,
          but usually provided by a system call such as _g_e_t_h_o_s_t_-
          _n_a_m_e(2) or _u_n_a_m_e(2).

     -H _h_o_s_t_d_o_m_a_i_n
          set hostdomain.  The default is configuration depen-
          dent.

     -F _a_d_d_r_e_s_s
          use _a_d_d_r_e_s_s on the From: line in locally generated
          mail.

     -p _p_a_t_h_f_i_l_e
          Set path database file name if not /usr/lib/uucp/paths.



                                                                1






SMAIL(8)



     -a _a_l_i_a_s_f_i_l_e
          For sites without sendmail, set alias database file
          name if not in the place defined at compile time (see
          ALIASES in defs.h).  This is usually /_u_s_r/_l_i_b/_a_l_i_a_s_e_s

     -n _n_a_m_e_l_i_s_t
          _s_m_a_i_l supports another type of aliasing intended for
          full name resolution using a sorted file, _n_a_m_e_l_i_s_t, of
          name/address pairs.  This allows mail to
          George.P.Burdell@gatech.edu to be delivered appropri-
          ately.  These aliases are by their nature very simple
          since they are not composed of long lists of recipients
          for each alias.  They are also numerous, since mail to
          George.P.Burdell may be addressed to Burdell,
          G.Burdell, George.Burdell, P.Burdell, G.P.Burdell, or
          George.P.Burdell.  This simpler form of aliasing uses
          the same fast searching algorithm that is used for the
          paths file, so it keeps resolution time manageable.

     -q _n_u_m_b_e_r
          Take _n_u_m_b_e_r as the queueing threshold.  When routing
          mail ( -_r, -_R, or domain addressed mail ) to a given
          host, if the cost listed in the _p_a_t_h_s file is less than
          the queueing threshold, then the mail will be sent
          immediately.  This overrides the default threshold (see
          QUEUECOST in defs.h) of DEDICATED+LOW.

     -m _n_u_m_b_e_r
          At most _n_u_m_b_e_r jobs will be handed to uux for immediate
          delivery by a single invocation of _s_m_a_i_l (see MAXNO-
          QUEUE in defs.h).

     -u _u_u_x_f_l_a_g_s
          Use _u_u_x_f_l_a_g_s as the flags passed to uux for remote
          mail.  This overrides any of the default values and
          other queueing strategies.

     -c   Consult the paths file for the cost of the path even
          when not routing the mail.  This makes it possible to
          use the cost information when sending pure UUCP path
          mail without rerouting it.

     -r   Route the first component of a UUCP path (host!address)
          in addition to routing domain addresses (user@domain).

     -R   Reroute UUCP paths, trying successively larger right-
          hand substrings of a path until a component is recog-
          nized.

     -l   Instead of routing a domain address, send it to the
          local mailer for processing.  Normally, only local
          addresses go to the local mailer.



2






                                                         SMAIL(8)



     -L   Send all addresses to the local mailer for processing,
          including UUCP paths.

     Most of the flags are also compile time options, since _u_u_x
     does not normally invoke _r_m_a_i_l with the desired flags.
     _s_m_a_i_l resets any preset -l or -L flags.  -l flag causes
     rmail to send all domain addresses through the local mailer,
     to process addresses for non UUCP domains.  The -L flag
     causes rmail to send even explicit UUCP paths through the
     local mailer, presumably to make use of other transport
     mechanisms.  In both cases, rmail defers any routing until
     smail gets hold it.

ADDRESSES
     _s_m_a_i_l/_r_m_a_i_l understands "user@domain" to be a domain
     address, "host!address" to be a UUCP path, and anything else
     to be a local address.

     Because hostile _r_m_a_i_l'_s unpredictably interpret mixed
     UUCP/domain addresses, _s_m_a_i_l/_r_m_a_i_l understands "domain!user"
     to be a domain address, and generates "path!domain!user"
     when mailing to a cognate _s_m_a_i_l/_r_m_a_i_l host.  To distinguish
     domain "domain!user" from UUCP "host!address", "domain" con-
     tains at least one (1) period.  Unlike the old /_b_i_n/_r_m_a_i_l,
     _s_m_a_i_l/_r_m_a_i_l gives precedence to @ over ! when parsing mixed
     addresses, thus a!b@c is parsed as (a!b)@c, rather than
     a!(b@c).

ROUTING
     Because _s_m_a_i_l/_r_m_a_i_l is the UUCP transport mechanism, it can
     only effect delivery on UUCP paths and local addresses;
     domain addresses require resolution into UUCP paths or local
     addresses. To resolve a domain address, _s_m_a_i_l/_r_m_a_i_l finds a
     route to the most specific part of the domain specification
     listed in the routing table.  Two degrees of resolution can
     occur:

          Full resolution: _s_m_a_i_l/_r_m_a_i_l finds a route for the
          entire domain specification, and tacks the user specif-
          ication onto the end of the UUCP path.  The address can
          also fully resolve to a local address (the UUCP path is
          null).

          Partial resolution: _s_m_a_i_l/_r_m_a_i_l finds a route for only
          righthand part of the domain specification, so it tacks
          the complete address (in the form domain!user) onto the
          end of the UUCP path.  Since this syntax is not widely
          understood, UUCP gateways listed in the path database
          must install new UUCP software, either _s_m_a_i_l/_r_m_a_i_l or
          new _s_e_n_d_m_a_i_l configuration files (or both).





                                                                3






SMAIL(8)



     It is an error if a partially resolved address routes to the
     local host (a null UUCP path), since according to the rout-
     ing table, the local host is responsible for resolving the
     address more fully.

     The -r flag causes _s_m_a_i_l/_r_m_a_i_l to attempt to route the first
     component of a UUCP path, probably so it can impress people
     with how many UUCP hosts it knows.  If this fails, it passes
     the unrouted address to _u_u_x, in case the path database is
     not complete.  The -R flag causes _s_m_a_i_l/_r_m_a_i_l to take a UUCP
     path and route the rightmost component of the path (save the
     user name) possible.  This is mostly for hosts that have
     very up-to-date routing tables.

     If a route cannot be discerned from the available routing
     database, then one more attempt to route the mail is made by
     searching for an entry in the database for a route to a
     _s_m_a_r_t-_h_o_s_t. If this entry exists, then the mail will be for-
     warded along that route to be delivered.  This allows a host
     to depend on another, presumably better informed, host for
     delivering its mail.  This kind of arrangement should be
     worked out, _i_n _a_d_v_a_n_c_e, with the _s_m_a_r_t-_h_o_s_t's administrator.

     After _s_m_a_i_l/_r_m_a_i_l resolves an address, it reparses it to see
     if it is now a UUCP path or local address.  If the new
     address turns out to be another domain address, smail com-
     plains because we don't like to resolve more than once.
     This error occurs when an address partially resolves the
     local host.

     By default, _s_m_a_i_l will not alter the explicit bang path
     routing of any mail message.  If the stated path is unuse-
     able, (i.e., the next hop host is unknown) then smail will
     apply ALWAYS routing, and attempt to deliver the mail to the
     potentially new address.  If this fails too, then REROUTE
     routing will be applied to the address, and another attempt
     to deliver is made.  Lastly, an attempt to find a path to a
     better informed host _s_m_a_r_t-_h_o_s_t will be made and the mail
     passed to that host.

FROMMING
     _s_m_a_i_l/_r_m_a_i_l collapses From_ and >From_ lines to generate a
     simple from argument, which it can pass to _s_e_n_d_m_a_i_l or use
     to create its own "From" line.  The rule for fromming is:
     concatenate each "remote from" host (separating them by
     !'s), and tack on the address on the last From_ line; if
     that address is in user@domain format, rewrite it as
     domain!user; ignore host or domain if either is simply the
     local hostname.  It also removes redundant information from
     the From_ line.  For instance:

                    ...!myhost!myhost.mydomain!...



4






                                                         SMAIL(8)



     becomes

                            ...!myhost!...

     Leading occurrences of the local host name are elided as
     well.

     _s_m_a_i_l/_r_m_a_i_l generates it own From_ line, unless it is feed-
     ing _s_e_n_d_m_a_i_l, which is happy with the -f_f_r_o_m argument.  For
     UUCP bound mail, _s_m_a_i_l/_r_m_a_i_l generates a "remote from host-
     name", where hostname is the UUCP hostname (not the domain
     name), so that From_ can indicate a valid UUCP path, leaving
     the sender's domain address in From:.

HEADERS
     Certain headers, To:, From:, Date, etc., are required by
     RFC822.  If these headers are absent in locally generated
     mail, they will be inserted by smail.  Also, a line of trace
     information, called a Received: line, will be inserted at
     the top of each message.

UNDELIVERABLE MAIL"
     Although nobody likes to have a mail message fail to reach
     its intended destination, it somtimes happens that way.
     Mail that is found to be undeliverable (i.e., unknown user
     or unknown host) will be returned to the sender.

FILES
     /usr/lib/uucp/paths      ascii path database
     /usr/lib/aliases         ascii alias database
     /usr/spool/uucp/mail.log      log of mail
     /tmp/mail.log            record of mail

SUPPORT
     Enhancements, enhancement requests, trouble reports, etc.,
     should be sent to

                      uucp-problem@Stargate.COM.


SEE ALSO
     _u_u_x(1), _p_a_t_h_s(8), _a_l_i_a_s_e_s(8)
     _s_e_n_d_m_a_i_l(8)
     _b_i_n_m_a_i_l(1) on BSD systems only
     _m_a_i_l(1) on System V systems

VERSION
     @(#)smail.8    2.5 (smail) 9/15/87







                                                                5



