; Program to swap IBM PC text graphics
; characters for something more printable.
; Much code cribbed from PC Magazine's PRSWAP.ASM (V4N19),
; but we use StdIn and StdOut instead of printer output.

CSEG	SEGMENT PUBLIC PARA 'CODE'
	ASSUME	CS:CSEG, DS:CSEG,ES:CSEG, SS:NOTHING

	org	100h			; COM program format
;
Unbox	PROC	NEAR
	jmp	Start			;skip over runtime data
;
; Swap table to translate (XLAT) characters to be printed
;
swap_table	db	'&'             ; Char 176      Graphic Fill
		db	'%'             ; Char 177      Graphic Fill
		db	'@'             ; Char 178      Graphic Fill
		db	4 dup ('|')     ; Char 179-182  Vertical
		db	2 dup ('*')     ; Char 183-184  Corner
		db	2 dup ('|')     ; Char 185-186  Vertical
		db	6 dup ('*')     ; Char 187-192  Corner
		db	2 dup ('-')     ; Char 193-194  Horizontal
		db	'|'             ; Char 195      Vertical
		db	'-'             ; Char 196      Horizontal
		db	'+'             ; Char 197      Intersection
		db	2 dup ('|')     ; Char 198-199  Vertical
		db	2 dup ('*')     ; Char 200-201  Corner
		db	2 dup ('-')     ; Char 202-203  Horizontal
		db	'|'             ; Char 204      Vertical
		db	'-'             ; Char 205      Horizontal
		db	'+'             ; Char 206      Intersection
		db	4 dup ('-')     ; Char 207-210  Horizontal
		db	4 dup ('*')     ; Char 211-214  Corner
		db	2 dup ('+')     ; Char 215-216  Intersection
		db	2 dup ('*')     ; Char 217-218  Corner
		db	'#'             ; Char 219      Graphic Fill
		db	'.'             ; Char 220      Graphic Fill
		db	'{'             ; Char 221      Graphic Fill
		db	'}'             ; Char 222      Graphic Fill
		db	'^'             ; Char 223      Graphic Fill

eofflag	db	0

; Miscellaneous equates
;
LOWEST_CHAR	equ	176		; Lowest graphic char in table
HIGHEST_CHAR	equ	223		; Highest graphic char in table
LOZENGE 	equ	254		; Lozenge character position

STDIN	EQU	0
STDOUT	EQU	1

Unbox	ENDP

Start	PROC	NEAR

	mov	dx,offset buff		;read/write buff

FileLup:
	cmp	eofflag,0		;last read an EOF?
	jnz	HitEof			;yep

	mov	cx,BUFFSIZE
	xor	bx,bx	;0		;read from StdIn
	mov	ah,3FH			;read from file/device
	int	21H
	jb	FilError		;read error, close down

	cmp	ax,cx			;read all we asked for?
	adc	eofflag,0		;if not, EOF flag is set
	mov	cx,ax			;bytes read into CX
	jcxz	Done			;all done

	call	Swap			;convert the buffer
	mov	dx,offset buff
	mov	cx,di			;last byte processed +1
	sub	cx,dx			;- start = bytes processed
	mov	bx,STDOUT		;write to StdOut
	mov	ah,40H			;write to file/device
	int	21H
	jnb	FileLup			;next buffer, please
	jmp	short FilError		;write error, die

HitEof:
	xor	al,al			;errorlevel 0
Done:
FilError:
	mov	ah,4CH			;terminate, ERRORLEVEL in AL
	int	21H

Start	ENDP


Swap	PROC	NEAR

	mov	si,dx			;read/write buffer
	mov	di,si			;align output with source
	mov	bx,offset swap_table	; Point to translate table with BX
	mov	dx,(HIGHEST_CHAR SHL 8) + LOWEST_CHAR
	mov	ah,LOZENGE		;last possible test constant

SwapLup:
	lodsb
	cmp	al,dl	;LOWEST_CHAR	; Is char to print below table range?
	jb	NoSwap			;yep, forget it
	cmp	al,dh	;HIGHEST_CHAR 	; Is char to print above table range
	ja	Check_Lozenge		; Yes, check for lozenge char
	 sub	al,dl	;LOWEST_CHAR	; Adjust AL for bias into table
	 xlat				; Translate to PrSwap's character
	 jmp	short Swapped

Check_Lozenge:				; Check for char 254
	cmp	al,ah	;LOZENGE	; Is char to print the lozenge?
	jne	NoSwap			; nope, forget it
	 mov	al,'='                  ; Make it a '='
Swapped:
	mov	[di],al			;stuff swapped char
NoSwap:
	inc	di			;bump to coincide with SI
	loop	SwapLup
	ret

Swap	ENDP

buff	label	byte			;dynamic buffer from here on
BUFFSIZE	EQU	60000		;likely size

CSEG	ENDS
	END	Unbox
