/*
    digext.c

        by
            Alvin Koh
            isakoh@zpcp53.att.com
            27 June 1991
            (with minor, approved Toad Hall Tweaks)
            (and Newt Hall Tweaks (tm), too! :-) )

    For extracting digest issues from files (including the INFO-ZIP
    .sma files recently posted). Files may contain more than one
    digest issue. Digests issues are located using the strings defined
    in the lookup table below.

    Digest issue files created have names like IZIP091.199.

    Notes:

    1.  Carriage returns (^M) are not removed from digests. For
        non-MSDOS users, use flip to remove them.

    2.  If a digest issue file already exists, it is not overwritten.

    3.  Right now, digext recognizes the digests listed in the lookup
        table. Add new digest info if you need to.

    4.  One added benefit of digext is that you can use it to rename
        your existing digests.

    Copyright (C) 1991, Alvin Koh.  All Rights Reserved.
    Permission is granted to any individual or institution to use, copy, or
    redistribute this software so long as it is not sold for profit,
    provided this copyright notice is retained.

    Feel free to enhance this program, but do send me a copy of
    your modifications.


    History:
    ~~~~~~~~

    1.01   27 June 1991  Alvin Koh (isakoh@zpcp53.att.com)
        Creation...

    1.02   28 June 1991   David Kirschbaum (kirsch@usasoc.soc.mil)
        Added include files for compilation under Turbo C.

    1.03   6 July 1991   Alvin Koh (isakoh@zpcp53.att.com)
        Added lookup table to support various digest types/formats.
        I have only tested digext with INFO-ZIP and UNIX-WIZARDS digests
        so far, as these are the 2 digests I subscribe to currently.
        Please send me your bug reports, enhancements and new formats.

    1.04   10 July 1991   Alvin Koh (isakoh@zpcp53.att.com)
        Changed the various *unwieldy* sscanf formats to short and
        more manageable ones. Volume and Issue variable changed from
        char[80] to int.

    1.04a  13 August 1991   Cave Newt (roelofs@amelia.nas.nasa.gov)
        Tweaks for VMS/VAXC compilation (didn't like void main; return 
        status must be zero or else interpreted strangely; added wildcard
        code).  Tested a little bit on INFO-ZIP digests.

*/

#include <stdio.h>
#include <string.h>

#define VERSION         "1.04a"
#define DATE            "13 August 1991"

#ifdef __STDC__
#include <process.h>        /* exit() */
#include <io.h>             /* access() */
#endif

#ifdef VMS
#  include <rms.h>
#  include <ssdef.h>
#  include <descrip.h>
   typedef struct direct {
       int d_wild;		/* flag for wildcard vs. non-wild */
       struct FAB fab;
       struct NAM nam;
       char d_qualwildname[NAM$C_MAXRSS + 1];
       char d_name[NAM$C_MAXRSS + 1];
   } DIR;
   int _vms_findfirst(char *, DIR *);
   int _vms_findnext(DIR *);
#endif /* VMS */

typedef struct INFO_TABLE_T INFO_TABLE;
struct INFO_TABLE_T {
    char *DIGEST_BEGIN;     /* start of digest */
    char *DIGEST_END;       /* end of digest */
    char *DIGEST_FMT;       /* format of digest name */
    char *DIGEST_SCAN;      /* scanf format to extract volume/issue number */
} info_table[] = {

    "INFO-ZIP Digest",                 /* tested by Alvin Koh */
    "End of INFO-ZIP Digest",
    "IZIP%03d.%03d",
    "%*[^V] %*s %d %*c %*s %d",

    "Info-IBMPC Digest",               /* tested by Alvin Koh */
    "End of Info-IBMPC Digest",
    "IIBM%03d.%03d",
    "%*[^V] %*s %d %*c %*s %d",

    "INFO-C Digest",
    "End of Info-C Digest",
    "IC%03d.%03d",
    "%*[^V] %*s %d %*c %*s %d",

    "INFO-WIZARD Digest",
    "End of Info-WIZARD Digest",
    "IWIZ%03d.%03d",
    "%*[^V] %*s %d %*c %*s %d",

    "Info-Kermit Digest",              /* tested by Alvin Koh */
    "End of Info-Kermit Digest",
    "IKER%03d.%03d",
    "%*[^V] %*s %d %*c %*s %d",

    "UNIX-WIZARDS Digest",             /* tested by Alvin Koh */
    "End of UNIX-WIZARDS Digest",
    "UWIZ%03d.%03d",
    "%*[^V] %*c %d %*c %d",

    "VIRUS-L Digest",                  /* tested by Alvin Koh */
    "End of VIRUS-L Digest",
    "VL%03d.%03d",
    "VIRUS-L %*[^V] %*s %d %*c %*s %d",

    /* add new info after this line */

    /* add new info before this line */

    NULL, NULL, NULL, NULL
};

#ifdef VAXC
int main(int argc, char *argv[])
#else /* !VAXC */
void main(argc, argv)
int argc;
char *argv[];
#endif /* ?VAXC */
{
    FILE *fi;               /* digest source descriptor */
    FILE *fo;               /* digest file descriptor */
    char s[BUFSIZ];         /* line of text from digest source */
    int Volume;             /* digest volume number */
    int Issue;              /* digest issue number */
    char digest[80];        /* name of digest file */
    int in_digest = 0;      /* 'in digest' flag */
    int i;
    INFO_TABLE *it;         /* ptr for searching info table */
    char digest_id[80];     /* storage for digest name */
    char keyword[80];       /* use for locate 'Digest' keyword */
#ifdef VMS
    DIR d;                  /* struct direct for VMS wildcards */
#endif /* VMS */

    if (argc == 1) {
        printf("digext - The Digest Extractor v%s  (%s)\n", VERSION, DATE);
        printf("(C)Copyright 1991, Alvin Koh. All Rights Reserved\n\n");
        printf("Usage: digext file [ file ... ]\n");
        exit(0);
    }

    for (i = 1; i < argc; i++) {

        /* open raw digest source */
#ifdef VMS
        _vms_findfirst(argv[i], &d);
        while (_vms_findnext(&d) == 0) {
        if ((fi = fopen(d.d_name, "r")) == NULL) {
#else /* !VMS */
        if ((fi = fopen(argv[i], "r")) == NULL) {
#endif /* ?VMS */
            printf("Can't open %s\n", argv[i]);
            continue;
        }

#ifdef VMS
        printf("Processing %s ...\n", d.d_name);
#else /* !VMS */
        printf("Processing %s...\n", argv[i]);
#endif /* ?VMS */

        /* look for start of digest issue */
        while (fgets(s, BUFSIZ, fi) != NULL) {

            /* found it */
            if (!in_digest) {

                /* look for 'Digest' keyword */
                sscanf(s, "%s %s", digest_id, keyword);

                if (strcmp(keyword, "Digest") != 0)
                    continue;

		/* clear keyword to prevent re-loop */
		keyword[0] = '\0';

                /* look up info table */
                it = info_table;
                while (it->DIGEST_BEGIN &&
                        strncmp(it->DIGEST_BEGIN, digest_id, strlen(digest_id)))
                    it++;

                if (it->DIGEST_BEGIN == NULL) {
                    printf("No info available for %s Digest\n", digest_id);
                    continue;
                }

                /* scan for volume/issue number */
                sscanf(s, it->DIGEST_SCAN, &Volume, &Issue);

                /* form name of digest issue */
                sprintf(digest, it->DIGEST_FMT, Volume, Issue);

                /* if already exists, skip */
                if (access(digest, 00) == 0) {
                    printf("\t%s already exists\n", digest);
                    continue;
                }
                printf("\tExtracting %s Digest Volume %d Issue %d\n", digest_id, Volume, Issue);

                /* create issue file */
                if ((fo = fopen(digest, "w")) == NULL) {
                    printf("Can't create %s\n", digest);
#ifdef VMS
                    exit(0);   /* VMS interprets exit statuses annoyingly */
#else /* !VMS */
                    exit(1);
#endif /* ?VMS */
                }

                /* set 'in digest' flag */
                in_digest = 1;
            }

            /* found end of digest */
            if (in_digest && !strncmp(s, it->DIGEST_END, strlen(it->DIGEST_END))) {
                /* reset flag */
                in_digest = 0;

                /* print ending lines */
                fprintf(fo, "%s", s);

                if (fgets(s, BUFSIZ, fi) != NULL)
                    fprintf(fo, "%s\n", s);

                /* close digest */
                fclose(fo);
            }

            /* inside digest, copy lines */
            if (in_digest)
                fprintf(fo, "%s", s);
        }

        /* close digest source */
#ifdef VMS
        fclose(fi);
        } /* end while (_vms_findnext has more files) */
#else /* !VMS */
        fclose(fi);
#endif /* ?VMS */
    }

    printf("Done\n");
    exit(0);
#ifdef VAXC
    return(0);   /* to satisfy the compiler warning about void return type */
#endif
}



#ifdef VMS

/*---------------------------------------------------------------------------

    _vms_findfirst() and _vms_findnext(), based on public-domain DECUS C
    fwild() and fnext() routines (originally written by Martin Minow, poss-
    ibly modified by Jerry Leichter for bintnxvms.c), were written by Greg
    Roelofs on or around 2 March 1991 and are still in the public domain.
    Routines approximate the behavior of MS-DOS (MSC and Turbo C) findfirst
    and findnext functions.  Most recent modifications, 13 August 1991.

  ---------------------------------------------------------------------------*/

int _vms_findfirst( char *wildname, DIR *d )
/*
 * Do wildcard setup
 */
{
#ifdef DEBUG
    printf("  findfirst working on DIR ptr %u\n", d);
#endif
    /* set up the FAB and NAM blocks. */
    d->fab = cc$rms_fab;		   /* initialize fab */
    d->nam = cc$rms_nam;		   /* initialize nam */

    d->fab.fab$l_nam = &d->nam;		   /* fab -> nam */
    d->fab.fab$l_fna = wildname;	   /* argument wild name */
    d->fab.fab$b_fns = strlen(wildname);   /* length */

    d->nam.nam$l_esa = d->d_qualwildname;  /* qualified wild name */
    d->nam.nam$b_ess = NAM$C_MAXRSS;	   /* max length */
    d->nam.nam$l_rsa = d->d_name;	   /* matching file name */
    d->nam.nam$b_rss = NAM$C_MAXRSS;	   /* max length */

    /* parse the file name */
    if (sys$parse(&d->fab) != RMS$_NORMAL)
        return -1;

    /* have qualified wild name (i.e., disk:[dir.subdir]*.*); null-terminate
     * and set wild-flag */
    d->d_qualwildname[d->nam.nam$b_esl] = '\0';
    d->d_wild = (d->nam.nam$l_fnb & NAM$M_WILDCARD)? 1 : 0;   /* not used... */
#ifdef DEBUG
    printf("  incoming wildname:  %s\n", wildname);
    printf("  qualified wildname:  %s\n", d->d_qualwildname);
#endif

    return 0;   /* OK */
}


int _vms_findnext( DIR *d )
/*
 * Match the next valid file.  Return 0 if successful, -1 if failed.
 */
{
    register int errorcode;


#ifdef DEBUG
    printf("  findnext working on DIR ptr %u\n  %s\n  %s\n", d, 
      d->d_qualwildname, d->d_name);
    printf("    d->d_qualwildname = %u, d->nam.nam$l_esa = %u\n",
      d->d_qualwildname, d->fab.fab$l_nam->nam$l_esa);
    printf("    d->d_name = %u, d->nam.nam$l_rsa = %u\n", d->d_name, 
      d->fab.fab$l_nam->nam$l_rsa);
#endif
    for (;;) {
        d->fab.fab$w_ifi = 0;	/* internal file index:  what does this do? */

        /* get next match to possible wildcard */
        if ((errorcode = sys$search(&d->fab)) == RMS$_NORMAL) {
            d->d_name[d->nam.nam$b_rsl] = '\0';   /* null terminate */
#ifdef DEBUG
            printf("  normal:  %s\n", d->d_name);
#endif
            return 0;   /* OK */
        } else if (errorcode == RMS$_PRV) {
            /* sys$search() found something, but we don't have privileges
             * to open it.  Look for another.  (Never seems to occur.) */
#ifdef DEBUG
            d->d_name[d->nam.nam$b_rsl] = '\0';   /* null terminate */
            printf("  protected:  %s\n", d->d_name);
#endif
            continue;
        } else {
            /* can't find a file--should be RMS$_NMF */
#ifdef DEBUG
            d->d_name[d->nam.nam$b_rsl] = '\0';   /* null terminate */
            printf("  error/no more files:  %s , code = %d\n",
              d->d_name, errorcode);
#endif
            return -1;
        }
    }
} /* end function _vms_findnext() */

#endif /* VMS */
