;---------------------------------------------------------------------------
; Install_Check:
;   If there is a copy already in memory, then when this is executed again,
;   there will be two copies.  This procedure compares the currently running
;   copy with the currently TSR copy.  It searches the first 16 bytes of the
;   UMBs up to the current one.  If it doesn't match then there's not a copy.
;   If it does match, it is very, very likely it's the same program. The 1st
;   word is NOT'ed to ensure only a running copy is found.  If the copy is
;   removed from memory, then it is NOT'ed again since it won't really be 
;   removed, just unallocated.  Otherwise there would appear to be many
;   copies running in memory when they are really unallocated and doing
;   nothing. If it is already installed, then ES will contain the segment and 
;   the carry flag is cleared.
;
;   Before:
;           CS = Current Code Segment
;   After:
;           Carry Set = Not found
;           Carry Clr = Found
;           ES = Segment found at or CS if not found
;   Changes:
;           Nothing
;---------------------------------------------------------------------------
Install_Check   Proc Far
        Assume CS:Code,DS:Nothing,ES:Nothing
        Push BX
        Push AX
        Push SI
        Push DI
        Push CX
        
        Not Word Ptr CS:Start       ; Fingerprint
        Mov BX,0A000h               ; Start in UMB's
        Mov AX,CS                   ; Store CS
        
Loop1:   
        Inc BX                      ; Search next segment
        Mov ES,BX                  
        Cmp AX,BX                   ; It's not before CS so it's not installed
        JE NoCopy
        Mov SI,Offset Start
        Mov DI,SI
        Mov CX,16                   ; Check 16 bytes
        Repe Cmpsb                  ; Repeat if equal
        JNE Loop1                   ; Not installed here so check next segment
        CLC                         ; It is installed here as segment ES
Done:        
        Pop CX
        Pop DI
        Pop SI
        Pop AX
        Pop BX
        Ret
        
NoCopy:
        STC                         ; Not Found
        Jmp Short Done
        
Install_Check   EndP

