;---------------------------------------------------------------------------
; Program:  RestScr.Asm
;
; Author:   Steve Poulsen
;
; This procedure will restore the screen text/attr at SI with the location
; entered in CX and DX with CL = X1, CH = Y1, DL = X2, DH = Y2. SI should
; point to a location with the same number of words as characters to restore.
;
;---------------------------------------------------------------------------
RestScr Proc    Near
        Push AX
        Push BX
        Push DI
        Push SI
        Push CX
        Push ES
        
        Mov AX,0B800h                   ; Screen memory segment for color
        Mov ES,AX
        Mov AH,0Fh                      ; Check video mode
        Int 10h
        Cmp AL,07h                      ; Monochrome?
        JNE Clr
        Mov AX,0B000h                   ; Screen memory segment for mono
        Mov ES,AX
Clr:        
        Mov BL,CL
        Mov BH,0
        
        Mov AL,160
        Mul CH
        Mov DI,AX
        Add DI,BX
        Add DI,BX
C1:       
        Push DX
        Mov DX,CS:[SI] 
        Mov ES:[DI],DX
        Pop DX
        Cmp BL,DL
        JE N1
        Inc DI
        Inc DI
        Inc SI
        Inc SI
        Inc BL
        Jmp C1
N1:                                      ; Start of loop for vert. lines
        Inc DI
        Inc DI
        Inc SI
        Inc SI
        Inc BL
        Inc CH
        Cmp CH,DH
        JLE Clr
        
        Pop ES
        Pop CX
        Pop SI
        Pop DI
        Pop BX
        Pop AX
        Ret
RestScr EndP

