{ SEQFILE.PAS }
program SeqFiles;
{ Demonstrates writing data to a sequential record file
  and reading it back in }

const
  MaxRecords = 4;

type
  TDataRecord = record
                  Name        : String[20];
                  PhoneNumber : String[14];
                  Age         : Integer;
                end;

const
  DataRecords : Array[0..MaxRecords] of TDataRecord

              = ( (Name : 'George'; PhoneNumber : '262-1234'; Age : 10 ),
                  (Name : 'John'  ; PhoneNumber : '262-1235'; Age : 20 ),
                  (Name : 'Lisa'  ; PhoneNumber : '262-1236'; Age : 22 ),
                  (Name : 'Marcia'; PhoneNumber : '262-1237'; Age : 30 ),
                  (Name : 'Gwen'  ; PhoneNumber : '262-1238'; Age : 4 ) );


var
  I           : Integer;
  SeqFile     : File of TDataRecord;
  SampleRecord: TDataRecord;

begin
  Assign( SeqFile, 'SEQFILE.DAT');
  Rewrite( SeqFile );

  for I := 0 to MaxRecords  do
    Write( SeqFile, DataRecords[I] );

  Close ( SeqFile );

  Reset( SeqFile );
  For I := 0 to MaxRecords do
  begin
    Read( SeqFile, SampleRecord );
    with  SampleRecord  do
      Writeln('Name=', Name,', Phone #=', PhoneNumber, ', Age=', Age);
  end;

  Close ( SeqFile );

  Write('Press Enter when done.');
  Readln;


end. { program }
