function CopyAFile ( Source, Dest : String ) : Integer;

{ Purpose:
  Copies the filenamed in 'Source' to the file named in 'Dest'.

  Returns:
  0 = copy was okay
  1 = not enough RAM memory to copy the file
  2 = error occurred when writing to the 'Dest' file
  3 = Could not open the source file
  4 = Could not open the destination file
}
label
  ExitProc;

type
  TFileBuffer = Array [0..1023] of Byte;
    { Copies the file in 1k chunks.  For a larger buffer, increase
      the size of the byte array. }
var
  BytesIn  : Integer;   { Number of bytes read in }
  BytesOut : Integer;   { Number of bytes written out }
  F1 : File;            { F1=file to read, F2=file to write }
  F2 : File;
  FileBuffer : ^TFileBuffer;
  Dialog : PDialog;
  Bounds : TRect;

begin { CopyFile }

  New( FileBuffer );
  if  FileBuffer = NIL  then
    CopyAFile := 1 {Not enough RAM memory to do a copy}
  else
  begin

    { Open the source file }
    Assign ( F1, Source );
    {$I-}
    Reset ( F1, 1 );
    if  IoResult <> 0  then
    begin
      CopyAFile := 3; {Error on opening source file}
      goto ExitProc;
    end;

    { Open the destination file }
    Assign ( F2, Dest );
    Rewrite ( F2, 1 );
    if  IoResult <> 0  then
    begin
      CopyAFile := 4; {Error on opening the destination file}
      goto ExitProc;
    end; { if }

    repeat
      BlockRead ( F1, FileBuffer^, SizeOf(FileBuffer^), BytesIn );
      if  BytesIn > 0  then
      begin
        { Since we read something, go ahead and write it to the destination }
        BlockWrite ( F2, FileBuffer^, BytesIn, BytesOut );
        if  BytesIn <> BytesOut  then
        begin
          CopyAFile := 2; {Error occurred while writing the output}
          {$I-}
          Close ( F2 );
          Erase ( F2 );
          Close ( F1 );
          {$I+}
	  goto ExitProc;
        end; { begin }
      end; { if }
    until  BytesIn = 0;

    CopyAFile := 0;
    Close ( F1 );
    Close ( F2 );

  end; { begin }

ExitProc:

  if  FileBuffer <> NIL  then
    Dispose (FileBuffer);

end; { CopyAFile  }

