                                     (* Chapter 15 - Program 5 *)
unit CarTruck;

interface

uses Vehicles;

type
   Car = object(Vehicle)
      Passenger_Load : integer;
      constructor Init(In_Wheels : integer;
                       In_Weight : real;
                       People    : integer);
      function Passengers : integer;
   end;


   Truck = Object(Vehicle)
      Passenger_Load : integer;
      Payload        : real;
      constructor Init(People : integer;
                       Max_Load : real;
                       In_Wheels : integer;
                       In_Weight : real);
      function Efficiency : real;
      function Wheel_Loading :real;
   end;

implementation

   constructor Car.Init(In_Wheels : integer;
                        In_Weight : real;
                        People    : integer);
   begin
      Wheels := In_Wheels;
      Weight := In_Weight;
      Passenger_Load := People;
   end;

   function Car.Passengers : integer;
   begin
      Passengers := Passenger_Load;
   end;

   constructor Truck.Init(People : integer;
                          Max_Load : real;
                          In_Wheels : integer;
                          In_Weight : real);
   begin
      Passenger_Load := People;
      Payload := Max_Load;
      Vehicle.Init(In_Wheels, In_Weight);
   end;

   function Truck.Efficiency : real;
   begin
      Efficiency := 100.0 * Payload / (Payload + Weight);
   end;

   function Truck.Wheel_Loading : real;
   begin
      Wheel_Loading := (Weight + Payload)/Wheels;
   end;

end.




{ Result of execution

(This file cannot be executed)

}