                                         (* Chapter 14 - Program 7 *)
program List_Pascal_Source_Files;   (* For TURBO Pascal 4.0 or 5.0 *)

(* This program can be used to list programs written in any language
   on the line printer.  It will list the filename, the latest date
   and time when the file was modified, and the contents with line
   numbers.  If there are more than 70 characters on any line, the
   remaining characters will be spilled to the next line.  To space
   the paper up, a formfeed is used.                               *)

Uses Printer, Dos;

const Max_Lines_Per_Page = 55;

type Command_String = string[127];

var Input_File      : text;
    Input_Line      : string[140];
    Line_Number     : integer;
    Lines_Printed   : integer;
    Page_No         : integer;
    Index           : integer;
    Filename        : Command_String;
    Date            : DateTime;


procedure Initialize; (* ****************************** initialize *)
var Time_And_Date : longint;
begin
   if ParamCount = 1 then
      Filename := ParamStr(1)
   else begin
      Write('Enter filename ----> ');
      Readln(Filename);
   end;
   Assign(Input_File,Filename);
   Reset(Input_File);
   Line_Number := 1;
   Lines_Printed := 66; (* This is to force a header immediately *)
   Page_No := 1;
   GetFTime(Input_File, Time_And_Date);
   UnpackTime(Time_And_Date, Date);
end;


procedure Read_A_Line; (* *************************** read a line *)
begin
   for Index := 1 to 140 do Input_Line[Index] := ' ';
   Readln(Input_File,Input_Line);
end;


procedure Format_And_Print; (* ****************** format and print *)
var Line_Length : byte;
begin
   Write(Lst,Line_Number:6,'  ');
   Line_Length := 0;
   for Index := 1 to 140 do begin
      if Input_Line[Index] <> ' ' then Line_Length := Index;
   end;
   for Index := 1 to Line_Length do
      Write(Lst,Input_Line[Index]);
   Writeln(Lst);
   Lines_Printed := Lines_Printed + 1;
   Line_Number := Line_Number + 1;
end;


procedure Check_For_Page; (* ********************** check for page *)
begin
   if Lines_Printed > Max_Lines_Per_Page then begin
      if Page_No > 1 then
         Writeln(Lst,Char(12));
      Writeln(Lst);
      Write(Lst,'     ');
      Write(Lst,'Source file --->',Filename:13);
      Write(Lst,Date.Month:5,'/',Date.Day:2,'/',Date.Year:2);
      Write(Lst,Date.Hour:5,':',Date.Min:2,':',Date.Sec:2);
      WriteLn(Lst,'   Page':10,Page_No:4);
      Writeln(Lst);
      Write('Source file --->',Filename:12);
      Writeln(' page':12,Page_No:4);
      Page_No := Page_No + 1;
      Lines_Printed := 1;
   end;
end;


begin  (* ******************************************* main program *)
   Initialize;
   Check_For_Page;
   repeat
      Read_A_Line;
      Format_And_Print;
      Check_For_Page;
   until Eof(Input_File);
   Writeln(Lst,Char(12));
end.  (* of main program *)
