;=======================================================================
; MODULE NAME:  Cases.ASM
; DEPENDENCIES: (None)
; LAST MOD ON:  9005.08
; PROGRAMMER:   Naoto Kimura
;
;     This is the assembly code for the routines in the StrUtil unit.
; Many of the routines were rewritten in the hopes that it will not
; only reduce the memory requirement, but also reduce the execution
; time.
;
;     This file should be assembled with Turbo Assembler.  If you need
; to use another assembler, then you should keep some things in mind.
;
; The TPASCAL memory model sets up automatically:
; * the standard Turbo Pascal entry code
;      push bp
;      mov bp,sp
; * the standard Turbo Pascal exit code
;      pop bp
;      ret n
; * the order of the arguments don't need to be reversed in the
;   assembly code.
;-----------------------------------------------------------------------
; 9001.20     Naoto Kimura
;             * Initial version created
;
; Modification history:
;
; 9002.14     Naoto Kimura
;             * Fixed bug in UpperStr and LowerStr routines (involved
;               weird bug(?) in assembler) :
;
;                   mov al,[bl+TBL]   ====>  mov al,[bx+TBL]
;
; 9002.23     Naoto Kimura
;             * Started to optimize some of the functions by rewriting
;               the translating functions to use the XLAT instruction.
; 9005.05     Naoto Kimura
;             * Broke up assembler modules into separate files to try
;               to decrease overhead (although the overhead is pretty
;               small, it's always nice to make available whatever
;               memory the user can use).
;=======================================================================
.MODEL   TPASCAL
LOCALS

.DATA

EXTRN	UpperTbl:BYTE
EXTRN	LowerTbl:BYTE
EXTRN	StdLower:BYTE

.CODE

;-----------------------------------------------------------------------
;FUNCTION LoCase ( C : Char ) : Char
;
;     This function performs the opposite function as the UpCase
; function; it takes an upper case character and transforms it into
; its lower case form.
;
; REGISTER USAGE:  AX	-- Return value
;                  BX	-- Destroyed
;-----------------------------------------------------------------------
LoCase		PROC FAR C:BYTE
		PUBLIC	LoCase
		mov	al,[C]
		mov	bx,OFFSET StdLower
		xlat
		ret
LoCase		ENDP

;-----------------------------------------------------------------------
;FUNCTION LoCase2 ( C : Char ) : Char
;
;     This function performs the opposite function as the UpCase
; function; it takes an upper case character and transforms it into
; its lower case form.
;
; REGISTER USAGE:  AX	-- Return value
;                  BX	-- Destroyed
;-----------------------------------------------------------------------
LoCase2		PROC FAR C:BYTE
		PUBLIC	LoCase2
		mov	al,[C]
		mov	bx,OFFSET LowerTbl
		xlat
		ret
LoCase2		ENDP

;-----------------------------------------------------------------------
;FUNCTION UpCase2 ( C : Char ) : Char
;
;     This function performs the opposite function as the UpCase
; function; it takes an upper case character and transforms it into
; its lower case form.
;
; REGISTER USAGE:  AX	-- Return value
;                  BX	-- Destroyed
;-----------------------------------------------------------------------
UpCase2		PROC FAR C:BYTE
		PUBLIC	UpCase2
		mov	al,[C]
		mov	bx,OFFSET UpperTbl
		xlat
		ret
UpCase2		ENDP

;-----------------------------------------------------------------------
;FUNCTION UpperStr ( S : String ) : String
;
;     This function returns the passed string with all the lower case
; characters transformed into upper case characters.
;
; REGISTER USAGE:  AX			-- Return value
;                  BX,CX,DI,SI,ES	-- Destroyed
;-----------------------------------------------------------------------
UpperStr	PROC FAR S:DWORD  RETURNS Result:DWORD
		PUBLIC	UpperStr
		USES	DS
		mov	dx,SEG DATA
		les	di,[Result]	; get addr of function result
		lds	si,[S]		; get addr of function parameter
		xor	ax,ax
		cld			; forward string op
		lodsb			; get length
		stosb			; copy length
		or	ax,ax		; null string ?
		jz	@@done
		mov	cx,ax
		mov	bx,OFFSET UpperTbl
		xor	ax,ax
@@copy:		lodsb
		push	ds
		mov	ds,dx
		xlat			; transform
		pop	ds
		stosb
		loop	@@copy
@@done:		mov	ds,dx
		ret
UpperStr	ENDP

;-----------------------------------------------------------------------
;FUNCTION LowerStr ( S :String ): String
;
;     This function returns the passed string with all the upper case
; characters transformed into lower case characters.
;
; REGISTER USAGE:  AX			-- Return value
;                  BX,CX,DI,SI,ES	-- Destroyed
;-----------------------------------------------------------------------
LowerStr	PROC FAR S:DWORD RETURNS Result:DWORD
		PUBLIC	LowerStr
		mov	dx,ds
		les	di,[Result]	; get addr of function result
		lds	si,[S]		; get addr of function parameter
		xor	ax,ax
		cld			; forward string op
		lodsb			; get length
		stosb			; copy length
		or	ax,ax		; null string ?
		jz	@@done
		mov	cx,ax
		mov	bx,OFFSET LowerTbl
		xor	ax,ax
@@copy:		lodsb
		push	ds
		mov	ds,dx
		xlat			; transform
		pop	ds
		stosb
		loop	@@copy
@@done:		mov	ds,dx
		ret
LowerStr	ENDP

END
