;
; FIXMOUSE.ASM - by Kai Rohrbacher   (S_ROHRBACHER@IRAV1.IRA.UKA.DE)
;
; (very short) TSR-Program to stop the mouse cursor disappearing in
; TurboPascal 6.0 after pressing Alt-F5
;
; Original idea by Duncan Murdoch - all credits to him!
;

program segment para 'CODE'
        assume cs:program,ds:program,ss:program
        org 100h

inter   equ 33h       ;INT to intercept: mouse INT
count   equ 5Ch       ;word counter used for balancing hide/show mouse calls
oldint  equ 5Eh       ;4 bytes to hold old mouse INT
psp_amount equ 62h    ;use all but the first 62h bytes of the PSP segment

main:   jmp short init

;Here starts the new code for INT 33h
resident proc
start_resident:
        pushf      ;save all registers
        push ax
        push bx
        push cx
        push dx
        push si
        push di
        push ds
        push es

        or ah,ah        ;only continue processing if AH=0
        jne beende
        or al,al        ;on AL=0/16h/21h: reset counter, save state
        je reset
        cmp al,16h
        je reset
        cmp al,21h
        je reset
        cmp al,1        ;if AL=1 (show cursor): decrement counter
        je show_mouse
        cmp al,2        ;if AL=2 (hide cursor): increment counter
        je hide_mouse
        cmp al,17h      ;if AL=17h (restore state): balance original counter
        jne beende      ;by explicitly inc-/decrementing function calls
restore:
        cmp word ptr cs:[count],0
        je beende
        jl hide
        dec word ptr cs:[count]
        mov ax,1
chain:  pushf
        call dword ptr cs:[oldint]
        jmp short restore
hide:   inc word ptr cs:[count]
        mov ax,2
        jmp short chain

show_mouse:
        sub word ptr cs:[count],2
hide_mouse:
        inc word ptr cs:[count]
        jmp short beende
reset:  mov word ptr cs:[count],0

beende: 
        pop es
        pop ds
        pop di
        pop si
        pop dx
        pop cx
        pop bx
        pop ax
        popf
        jmp dword ptr cs:[oldint]   ;chain to old INT
end_resident:
resident endp

resident_length equ end_resident-start_resident
resident_offset equ start_resident-main+100h

;The initialization part relocates the above stuff into the PSP segment to
;regain as much RAM as possible (see "The Programmer's Guide To The IBM PC"
;by Peter Norton for further details)
init:
        push cs
        pop ds
        mov ax,35h shl 8+inter
        int 21h                  ;get actual INT 33h
        cmp bx,psp_amount        ;pointing to our routine?
        jnz install
        mov ah,9
        mov dx,offset Text ;yes, already installed: stop installation!
        int 21h
        mov ax,4c00h
        int 21h                  ;terminate program
Text    db 13,10,'Fixmouse already installed!',13,10,'$'

install:
        mov word ptr cs:[oldint],bx   ;save old vector
        mov word ptr cs:[oldint+2],es

        push cs                  ;do relocation
        pop es
        push cs
        pop ds
        mov si,resident_offset
        mov di,psp_amount        ;let code start at CS:psp_amount
        mov cx,resident_length
        cld
        rep movsb

        mov dx,psp_amount
        mov ax,25h shl 8+inter
        int 21h                 ;redirect INT 33h to our routine
        mov ah,9
        mov dx,offset aktiv     ;inform user
        int 21h

        push cs
        pop ds
        mov dx,psp_amount+resident_length
        int 27h                 ;terminate but stay resident
aktiv   db 13,10,'Fixmouse for TurboPascal 6.0 - by Kai Rohrbacher ',13,10
        db 13,10,'Fixmouse has been installed now!',13,10,'$'
program ends
        end main

;THAT'S ALL FOLKS!!!!!!!!!!!
