Title	DeviceS.ASM -- Display DOS Device Chain - 22-May-1989 - 03:10
	DOSSEG
	.MODEL  small
	.STACK
	.DATA

fail$ DB ' Device Header Chain NOT Found '
flgs DW 4C00h,0,0			; ErrLvl, Last Drive & RePlaced

kind$ DB 'Block'
	db	'Drives'
	db	'ABCDEFGHIJKLMNetWork'	;+11
	db	'Character'		;+31
	db	'Replaced'		;+40
	db	'Mappable Drives'	;+48
	DB	'System Date/Time'	;+63
	db	'EMMXXXX0'		;+79
	db	'Expanded Mem Mgr'
	db	'XMFXXXX0'		;+103
	db	'HI-MEM'
	db	' Busy Rpt'		;+117
newl	DB	13,10,'        $'
hdgm	DB	' Address Strat Inter Attr Type'
	db	' Device  Name         Remarks     '	;+30
Dev  Struc
	DB	'R',63  DUP (32)
Dev	EndS
DevS	Dev	32  DUP (<>)
SZ	Equ	SIZE    Dev

	.CODE

Main	Proc
	mov	ax,@data		; Make Data
	mov	DS,ax			; Addressable
	mov	ax,40h			; Search Data
	mov	ES,ax			; Segment of
	xor	di,di			; DOS for
	mov	al,'C'			; CON Device
;v1.1	mov	dl,'O'			; Segment to
;v1.1	mov	dh,'N'			; Store NUL and
	mov	dx,'NO'			;'ON' backwards			v1.1
	mov	cx,-1			; Other Devices
	xor	bp,bp			; Within DevS Array and
	call	DevFind			; Make Data Addressable by
	mov	ax,@data		; Extra Segment Register
	mov	ES,ax			; If DeviceS Found
	jnz	DoHdr			; Then Display Heading
	 mov	byte ptr flgs,1		; Else Display
	 mov	dx,offset fail$		; Error Message
	 mov	cx,31			; and Exit
	 jmp	short Show

DoHdr:	mov	dx,offset hdgm		; Heading
	mov	cx,SZ			; Line
	call	ShowMsg
	mov	bx,bp			; Set Limit for Sort by
	xor	bp,bp			; Ascending Addresses
	call	DevSort
DoDev:	mov	dx,offset DevS		; Point to DeviceS at
	mov	cx,SZ			;set line length		v1.1
	add	bp,cx	;SZ		; Place Where Unit(s)		v1.1
	add	dx,bp			; Will be Changed to
	mov	di,dx			; Disk Drive Letters
	add	di,40
;v1.1	mov	cx,SZ			; Set Line Length
Show:	call	ShowMsg			; If More Lines
	cmp	bp,bx			; To be Displayed
	jc	DoDev			; Then Loop for Next
Exit:	mov	ah,9			; Else End
	mov	dx,offset newl		; Last Line
	int	21h
	mov	ax,flgs			; ErrorLevel
	int	21h			; Exit to DOS
Main	EndP

DevSort Proc
	add	bp,SZ			; If Next Device Level
	mov	dx,bp			; Is ABOVE the Top Floor
	cmp	bp,bx			; Then Sorting is Done
	ja	DSexit			;

	mov	cx,8			; Else If Address
	mov	si,offset DevS		; Of Device at
	add	si,bp			; New Level is
	mov	di,si			; Less Than Next
	add	di,SZ			; Level Address
	rep	cmpsb
	jc	DevSort			; Then Advance

	mov	cx,SZ			; Else Copy
	mov	si,offset DevS		; Next Level
	add	si,bp			; Device Line
	add	si,cx	;SZ		; Into Basement or		v1.1
	mov	di,offset DevS		; Zero Array Member
	push	si
	rep	movsb
	mov	cx,SZ			; Copy
	mov	si,offset DevS		; Current
	add	si,bp			; Level Into
	pop	di			; Level Above
	rep	movsb

	mov	cx,SZ			; Complete
	mov	si,offset DevS		; Swap by
	mov	di,si			; Copying Zero
	add	di,bp			; Level to Current
	rep	movsb
DSsink: cmp	bp,SZ			; If ABOVE Ground Level
	ja	DSdown			; Then Sink to the Ground
DSdone: mov	bp,dx			; Else Restore Pre-Sink Level
	jmp	short DevSort		;  and Resume Sort Ascending

DSdown: mov	cx,8			; Compare the
	mov	di,offset DevS		; Current Level
	add	di,bp			; Address With
	mov	si,di			; Address in
	sub	si,SZ			; Lower Level
	rep	cmpsb			; If Current Higher
	jc	DSdone			; Then Sinking Done

	mov	si,offset DevS		; Else Copy
	mov	di,si			; Lower Level
	add	si,bp			; Device Line
	mov	cx,SZ			;load now			v1.1
	sub	si,cx	;SZ		; Into Zero or			v1.1
;done	mov	cx,SZ			; Basement Level
	rep	movsb
	mov	di,si			; Copy Current
	mov	cx,SZ			;load now			v1.1
	sub	di,cx	;SZ		; Into Lower
;done	mov	cx,SZ
	rep	movsb

	mov	si,offset DevS		; Complete Swap by
	mov	di,si			; Moving Previous
	add	di,bp			; From Basement
	mov	cx,SZ			; Into Current
	sub	bp,cx	;SZ		;do now				v1.1
	rep	movsb
;done	sub	bp,SZ			; Do Next Lower Level
	jmp	short DSsink		; Until Ground Level

DSexit: Xor	bp,bp			; Return BP=basement
	ret				;    and BX=top floor
DevSort EndP

DevFind Proc
	repne	scasb			; If NO "C"
	jcxz	DFexit			; Then Exit
	jne	DevFind			; Else If
	cmp	ES:[di],dx		; NO C"ON"
	jne	DevFind			; Then Look On
	mov	bx,ES:[di-7]		; Or If Attribute
	and	bx,801Fh		; Word Is NOT
	cmp	bx,8013h		; One for CON
	jne	DevFind			; Then Look Further

	sub	di,11			; Else Use Next
	mov	ES,ES:[di+2]		; Device Segment to
	xor	di,di			; Scan for "NU"L
	mov	ax,'UN'			; Device Header

FNloop: repne	scasw			; If Search in Vain
	jcxz	DFexit			; Then Zero Flag Exit
	cmp	byte ptr ES:[di],"L"	; Else If NOT NU"L"
	jne	FNloop			; Then Look Some More
	mov	bx,ES:[di-8]		; Else If Attribute
	and	bx,801Fh		; Word Is NOT Right
	cmp	bx,8004h		;  for NUL Device
	jne	FNloop			; Then Look Some More

	push	cx			; Else Preserve Counter
	sub	di,12			; Store NUL Data First

DFnext: add	bp,SZ			; Index of Next
	mov	bx,offset DevS		; Array Member
	Call	DevLine			; Store Device Data
;v1.1	mov	bx,ES:[di]		; Adjust ES:DI to
;v1.1	mov	ES,ES:[di+2]		; Next Device Address
	les	bx,dword ptr ES:[di]	;Adjust ES:DI..			v1.1
					;to next device address		v1.1
	mov	di,bx			; If Next Offset
	cmp	bx,-1			; Is NOT End of Chain
	jne	DFnext			; Then Store Next Member
	pop	cx			; Else Restore Counter
DFexit:
;v1.1	cmp	cx,0			; Return NZ If Found
	or	cx,cx			;v1.1
	ret				; OR ZR If NOT Found
DevFind EndP

DevLine Proc
	mov	ax,ES			; Store Segment
	add	bx,bp			; of Next Device
	call	AX2ASCh			; as HEX Address
	push	di			; Preserve and
	mov	ax,di			; Store Offset
	call	AX2ASCh			; HEX Address
	mov	ax,ES:[di+6]		; Store Strategy
	call	AX2ASCh			; Offset HEX Word
	mov	ax,ES:[di+8]		; Store Interrupt
	call	AX2ASCh			; Offset HEX Word
	mov	ax,ES:[di+4]
	inc	bx			; Position for
	mov	dx,ax			; Attributes
	call	AX2ASCh			; Storage
	add	di,10			; If Attribute of
	test	dx,8000h		; Character Device
	jnz	DoName			; Then Has a Name
	mov	si,offset kind$		; Else Copy
	mov	cx,5			; "Block"
	call	SI2BX			; Type
	test	ax,1000h		; If NOT NetWork
	jz	DoDisk			; Then Is Disk Drive
	add	si,20			; Else Point Source to
	mov	cx,8			; Copy "NetWork " to
	add	bx,cx			; Name Field and
	call	SI2BX			; End The Record
	jmp	DLdone

DoDisk: inc	bx			; Leave a Space
	mov	al,ES:[di]		; If Number of
	aam				; Units is More
	cmp	al,1			; Than Singular
	mov	cx,6			; Then "Drives"
	ja	Drives			; Else Cut to
	 dec	cx			; "Drive"
Drives: push	bx			; Preserve Destination
	call	SI2BX			; While Outputting
	pop	bx			; So As to be Able to
	add	bx,8			; Find "Name" Location
	mov	[bx],al			; and Store Unit(s)
	cmp	dx,0840h		; If NOT OCRM and IOCTL
	jne	DLlily			; Then NO Remarks
	 mov	si,offset kind$+48	; Else Make
	 add	bx,8			; Remark
	 mov	cx,15			; "Mappable
	 call	SI2BX			;  Drives"
DLlily: jmp	DLdone			; Lily Pad to Done

DoName: mov	si,offset kind$+31	; Store Type as
	mov	cx,9			; "Character"
	call	SI2BX
	add	bx,4			; Adjust Pointer to
	xor	si,si			; "Name" Zero Offset
	xchg	si,bx			; Swap Pointers to
	mov	cx,8			; Copy "dev_Name"
DNloop: mov	al,ES:[di+bx]		; Put a Name
	mov	DS:[si+bx],al		; Byte in Data
	inc	bx			; Advance Index
	loop	DNloop			; Until 8 Bytes

	add	bx,si			; Point to
	inc	bx			; "Remarks"
	mov	si,offset kind$+79	; If "EMMXXXX0"
	push	di			; Is NOT
	mov	cx,8			; Name In
	rep	cmpsb			; Device Line
	pop	di			; Restored
	jne	HIMEM?			; Then Check HI-MEM
	 jmp	short DLlast		; Else Copy Remark

HIMEM?: mov	si,offset kind$+103	; If "XMFXXXX0"
	mov	cx,8			; Is NOT Name
	rep	cmpsb			; In Device Line
	jne	DLbusy			; Then Check Busy
	 mov	cx,7			; Else Copy "HI-MEM "
	 call	SI2BX			; Into Remarks
DLbusy: test	dx,2000h		; If NOT Busy
	jz	DL?CON			; Then CONorCLK Replaced?
	 mov	si,offset kind$+117	; Else " Busy Rpt"
	 mov	cx,9
	 call	SI2BX
DL?CON: mov	si,offset kind$+40	; Pointer to
	mov	cx,8			; "Replaced"
	cmp	dx,8013h		; If NOT CON
	jne	DL?CLK			; Then Clock?
	 test	byte ptr flgs+4,3	; Else If Previous
	 jnz	DLrepl			; Then IS Replaced
	  or	byte ptr flgs+4,3	; Else Flag First
	  jmp	short DLdone

DL?CLK: cmp	dx,8008h		; If NOT Clock
	jne	DLdone			; Then Line Done
	test	byte ptr flgs+5,8	; Else If Previous
	jnz	DLrepl			; Then IS Replaced

	or	byte ptr flgs+5,8	; Else Flag System Clock
	mov	si,offset kind$+63
DLlast: mov	cx,16			; Copy Full Width
	call	SI2BX			; Remark and Done
	jmp	short DLdone

DLrepl: push	cx			; Remark IS
	call	SI2BX			; "Replaced"
	mov	si,offset hdgm+30	; " Device "
	pop	cx
	call	SI2BX
DLdone: pop	di			; Restore Offset
	ret				; to Device Header
DevLine EndP

SI2BX	Proc
	push	ax
SI2BXl: lodsb				; Transfer CX
	mov	[bx],al			; Characters
	inc	bx			; From [SI] to [BX]
	loop	SI2BXl			; SI and BX are
	pop	ax			; Advanced by CX
	ret
SI2BX	EndP

AX2ASCh Proc
	push	ax			; Preserve Value
	mov	al,ah			; Copy High Byte
	call	AX2HEX			; Do 2 HEX Digits
;v1.1	add	bx,2			; Advance Index
	inc	bx			;advance index			v1.1
	inc	bx			;(faster)			v1.1
	pop	ax			; Restore Value
	call	AX2HEX			; Do 2 HEX Digits
	add	bx,3			; Advance Index
	ret
AX2ASCh Endp

AX2HEX  Proc
	mov	ah,al			; Preserve Byte
	mov	cx,4			; Isolate High
	shr	al,cl			; Nibble and
	call	AL2HEX			; Make HEX
	mov	[bx],al			; Store it
	mov	al,ah			; Recover Byte
	and	al,0Fh			; Isolate Low
	call	AL2HEX			; Nibble to
	mov	[bx+1],al		; HEX digit
	ret
AX2HEX  EndP

AL2HEX  Proc
	add	al,'0'			; Make ASCII
	cmp	al,'9'			; If Decimal
	jle	ALexit			; Then Ok for HEX
	 add	al,7			; Else Make Letter
ALexit: ret

AL2HEX  EndP

ShowMsg Proc
	push	bx			; Preserve
	push	cx			; Counts and
	mov	si,dx			; Pointer
	mov	dx,offset newl		; Carriage
	mov	ah,9			; Return and
	int	21h			; Line Feed
	pop	cx			; Restore Count
	cmp	byte ptr [si],' '	; If a Record
	jne	SMproc			; Then Process
	 mov	bx,09h			; Else Underline
	 jmp	short SMnext

SMproc: mov	al,ES:[di]		; If Byte as a
	cbw				; Word Value
	cmp	al,' '			; Is Printable
	jnc	SMblue			; Then Display
	push	si			; Else Preserve
	mov	si,flgs+2		; Pointer While
	add	si,offset kind$+11	; Up-Date Next
	add	flgs+2,ax		; Drive Letter
	movsb				; Replace Unit(s)
	dec	ax			; If UnitS
;v1.1	jnz	SMmore			; Then Show More
;v1.1	 pop	si			; Else Restore
;v1.1	 jmp	short SMblue		; Display Pointer
	jz	SMblue1			;v1.1

SMmore: dec	ax			; Adjust for
	add	si,ax			; Last Drive
	lodsb				; Letter and
	mov	ah,' '			; Put Space
	xchg	ah,al			; Ahead of it
	push	ax			; Store
	mov	ah,'-'
	stosw				; " - " and Last
	pop	ax
	stosw				; Store Last and
SMblue1:				;v1.1
	pop	si			; Restore Pointer
SMblue: mov	bx,1Fh			; White on Blue
	mov	di,si			; Adjust Index to
	add	di,SZ			; Next Record
SMnext: cmp	cx,12h			; When Down to
	jnc	SMcolr			; Below 18 Bytes
	 mov	bx,4Fh			; Use White on Red
SMcolr: push	cx			; Preserve Count
	mov	cx,1			; While We
	mov	ax,920h			; Color me
	int	10h			; "purple"
	pop	cx			; Restore Count
	mov	ah,0Eh			; Teletype
SMbyte: lodsb				; Bytes
	int	10h			; Until
	loop	SMnext			; CX done
	pop	bx
	ret
ShowMsg EndP

	End	Main
