/*  Include file for the application program to create TIFF file */

/*  Data types in bytes */

#define LBYTE	1
#define LASCII	1
#define LSHORT	2
#define LLONG	4
#define LRATNL	8


/*  Tag list used by the application prg for full resolution data */

#define T_IMG_WIDTH	256		/* Image width */
#define T_IMG_LENGTH	257		/* Image length */
#define T_COMPRESS	259		/* Compression */
#define T_PHOTO 	262		/* Photometricinterpretation */
#define T_RWPRSTRP	278		/* Rowsperstrip */
#define T_XRESOL	282		/* xresolution */
#define T_YRESOL	283		/* yresolution */
#define T_PLANAR	284		/* Planarconfiguration */
#define T_BITS_SAMPLE	258		/* Bits per Sample */
#define T_SAMP_PIX	277		/* Samples per Pixel */


/*  Default values for the above mentioned Tags */

#define IMGWIDTH_VAL	2560		/* 300 dpi, 8.5" page width */
#define IMGLENGTH	3300		/* 300 dpi, 11" page length */
#define NO_COMPRESS	1		/* No compression for storage */
#define D1_HUFFMAN	2		/* 1D modified Huffman code */
#define PHOTO_DEF	0		/* 0 = white, 1 = black.*/
#define ROWSTRIP	50		/* 1 rows per strip */
#define X_NUM_VAL	300		/* 300 dpi along x axis */
#define X_DEN_VAL	1		/* used if x res in fraction */
#define Y_NUM_VAL	300		/* 300 dpi along y axis */
#define Y_DEN_VAL	1
#define PLANAR_DEF	1		/* Image data stored in 1 plane */
#define BITSSAMP	1		/* Image data 1 bit per pixel */
#define SAMPPIXEL	1		/* IMage data 1 sample per pixel */


#define FULRES_FILE	1		/* Subfile type is Full resolution */
#define SNULL		0000

#define SINGLE_PLANE	1		/* for pubspac display */
#define ONE_D_MOD	2		/* 1D modified Huffman code technique */
