/***************************************************************************\
*
* PVCS Software Configuration Management Control Information
*
* TIFFINT.H
*
* $Revision:   1.1  $
*
* $Date:   22 Apr 1988 15:00:20  $
*
* $Author:   BOBG  $
*
* $Logfile:   F:/PUBLIC/421/WORK/INCLUDE/TIFFINT.H_V  $
*
* $Log:   F:/PUBLIC/421/WORK/INCLUDE/TIFFINT.H_V  $
   
      Rev 1.1   22 Apr 1988 15:00:20   BOBG
   remove dependency on GAWB.H #define ID_FILEEXT
   
      Rev 1.0   21 Mar 1988 16:21:50   tomh
   Initial revision.
*
\***************************************************************************/

#ifndef tiffTYPES

#define tiffTYPES 1
/* manifests for tiff tags and other oddities */

#define TAG_IMWIDTH	256
#define TAG_IMLENGTH	257
#define TAG_BITSPIX	258
#define TAG_SAMPIX	277
#define TAG_ORIENT	274
#define TAG_PHOTOINTERP 262
#define TAG_SUBFILE	255
#define TAG_COMPRESS	0x103
#define TAG_FILLORD	0x10A
#define TAG_ROW_STRIP	0x116
#define TAG_MINSAMP	0x118
#define TAG_MAXSAMP	0x119
#define TAG_XRES	0x11A
#define TAG_YRES	0x11B
#define TAG_PLANAR	0x11C
#define TAG_GREYRES	0x122
#define TAG_GREYCRV	0x123
#define TAG_CELL_WIDTH	0x108
#define TAG_CELL_LENGTH 0x109

#define FULL_RES	1
#define PLANE_1 	1
#define BITSPERBYTE	8

#define FF_TIFF 	20		/* GAWB.H	ID_FILEEXT 	 */
#define FF_PCC		21		/* GAWB.H	ID_FILEEXT+1 */
#define FF_PCX		22		/* GAWB.H	ID_FILEEXT+2 */
#define FF_EPSF 	23		/* GAWB.H	ID_FILEEXT+3 */


#define NO_COMPRESS	1
#define D1_HUFFMAN	2
#define PHOTO_DEF	0
#define ROWSSTRIP	20
#define SAMPLEPIX_DEF	1
#define FILLORDER_DEF	1
#define MINSAMPLE_DEF	1
#define MAXSAMPLE_DEF	1
#define ORIENT_DEF	1
#define GREYRESUNIT_DEF 3

typedef struct ratio {
	long	upper;
	long	lower;
	}RATIO;

struct IMG_ATT {
	char	path[40];	/* file name */
	short	resolution;	/* is this the full or sub-sampled */
	unsigned short	imwidth;	/* width of the image */
	unsigned short	imlength;	/* length of the image */
	short	bits_sample;	/* bits per sample */
	short	compress;	/* compression tag */
	short	photointerp;	/* photointerpretation */
	short	fillorder;	/* order of pixels within a byte */
	short	orient; 	/* orientation of the scanned image */
	short	sample_pix;	/* how many samples per pixel */
	long	rows_strip;	/* how many scanned rows per strip */
	short	min_sample;	/* the minimum sample value */
	short	max_sample;	/* the maximum sample value */
	RATIO	xresolution;	/* the x resolution of the image */
	RATIO	yresolution;	/* the y resolution of the image */
	short	planarconfig;	/* how are the image planes stored */
	short	grey_res_unit;	/* the magnitute multipiler */
	short	*grey_curve;	/* pointer to the grey curve */
				/* should be as many values  */
				/* in the pointed to buffer  */
				/* as there are levels of grey */
	short	cell_width; 	/* halftone cell width */
	short	cell_length;	/* halftone cell height */
	short	threshhold;	/* line art of dithered */
	};

struct tiff_open {
   int BytesPerLine;	/* number of bytes needed to read one scan line */
   unsigned int TiffWidth;	/* width of image in pixels */
   unsigned int TiffLength;	/* length of image in pixels */
   int BitsPerPixel;	/* number of bits per pixel */
   int RowsPerStrip;	/* number of rows per strip */
   int BlackLevel;	/* variable describing if 0 or 1 = black */
   int ScanDirection;	/* direction of scan, refer to specification */
   int Tiffxresolution; /* x resolution */
   int Tiffyresolution; /* y resolution */
};

typedef struct tiff_open TIFF_DATA;
typedef struct IMG_ATT	 IMAG_ATTR;

#endif
