; FREQ.ASM --- TSR source for frequency logger.
;
;make file with turbo asm and linker:
;tasm freq.asm,,nul,nul;
;tlink /t freq,,nul,;
;
; make file with masm, link, exe2bin:
; masm freq.asm,,nul,nul;
; link freq,,nul,;
; exe2bin freq.exe freq.com
; del freq.exe
;
;Purpose: Maintains last access date and time for selected directories
;         of files. The file name, time and date are stored as normal
;         directory entries. The directory entries have 0 file
;         length and reside one level deeper in the directory tree,
;         inside a subdirectory with special name FREQ.USE.
;
;Use:     Create the subdirectory FREQ.USE inside a given subdirectory
;         (there will ultimately be many with this same name). Use the
;         DOS command MKDIR. This action determines which subdirectories
;         receive updates. No subdirectory FREQ.USE means no update takes
;         place. After loading the TSR, the updates to the subdirectories
;         are automatic, across all disks, even floppies.
;
;         Before doing a file entry update, the directory entry is
;         checked to see if it already exists. If so, then it is further
;         checked for file length 0. If either it fails to exist, or it
;         does exist with length 0, then the directory entry is created
;         with the system time and date and file length 0.
;
;         If the TSR is not loaded, then no updates take place. The
;         updates occur exactly when the TSR is loaded.
;
;         File names in the FREQ.USE subdirectories are normal in every
;         way: all DOS commands apply, including especially DIR and DEL.
;
;Version: 30 November 1991
;Authors: Grant B. Gustafson for the current version. Similar version
;         using files was developed by Greg Conner and Grant Gustafson.
;         Other authors will be added here as contributions are made.
;email:   gustafso@math.utah.edu.Internet
;Copyright:
;         The source code is jointly owned by the authors. It may be used
;         for educational purposes without limitation. Modified versions
;         of the sources are considered private copies and should bear
;         the new authors names.
;Responsibility:
;         This computer program is used at your own risk. If you use it,
;         then you assume responsibility for anything that happens as a
;         result of the program operation, including but not limited to
;         programming errors, faulty operation, file system destruction.
;         The authors are not responsible.
;
Cseg      segment public para
          assume  cs:Cseg, ds:nothing, es:nothing, ss:nothing

          org     080H
cmdline   label   byte                 ;pointer to command line

          org     100H
comentry: jmp     init


;previous interrupt handlers
        even
dos_int        label dword
old21          dw 2 dup (?)            ;old int21 vector
;***********************************************************************
;interrupt handler for int21
newint21 proc  near
         assume ds:nothing
        pushf                  ;save flags
        push    si
        mov     si,offset fn            ;are we to ignore updates?
        cmp     byte ptr cs:[si],1
        pop     si
        jne     ex21
        cmp     ax,'fr'                 ;check for install twice
        jne     ex20
        popf                            ;tried to install twice
        xor     ax,ax                   ;clear flags
        mov     ax,'eq'                 ;return code for install
        iret                            ;return from interrupt
ex20:
        cmp     ah,3dh
        jne    ex21
        call   update          ;update dir entry
ex21:   popf
        jmp    (dos_int)       ;transfer to previous int21 vector
newint21 endp

;******************************************************************************
;resident data section follows
;******************************************************************************


        even
;temporary stack used by interrupt handler
newss          dw      0               ;segment of our temporary stack
newsp          dw      0               ;initial stack pointer

;information saved about the calling program
oldss          dw      ?               ;stack segment
oldsp          dw      ?               ;stack pointer


;***********************************************************************
;update dir entry in ..\freq.use subdirectory.

update proc  near
       assume ds:nothing

;save current stack
       mov     oldss,ss
       mov     oldsp,sp

;switch to our stack
       cli
       mov     ss,newss
       mov     sp,newsp
       sti

;store registers
       push    ax
       push    bx
       push    cx
       push    dx
       push    si
       push    di
       push    es
       push    ds

        call    makefilename            ;make up new filename in FILEN
        call    openfile                ;test nonexistent or filelen=0
        cmp     ax,0                    ;returns 0 if not Ok to create
        jz      quit
        call    createfile              ;create file and close it.
quit:
;restore registers
       pop     ds
       pop     es
       pop     di
       pop     si
       pop     dx
       pop     cx
       pop     bx
       pop     ax

;restore stack
       cli
       mov     ss,oldss
       mov     sp,oldsp
       sti

       ret
update endp

openfile proc near
; FILEN=filename
; see if file exits. If so, see if it is 0 bytes long.

        assume ds:nothing
; open the file
        mov     ax,cs
        mov     ds,ax           ;ds=code segment at interrupt time
        mov     dx,offset FILEN ;file name 0 terminated
        mov     al,0            ;read only
        mov     ah,3dh          ;open file
        mov     si,offset fn    ;turn off ah=3dh trigger in newint21!
        mov     byte ptr ds:[si],0
        int     21h
        mov     bx,ax           ;bx=file handle
        mov     si,offset fn    ;turn on trigger again.
        mov     byte ptr ds:[si],1
        mov     ax,1            ;return ax=1 if ok to create file
        jc      stop            ;ok to create it, file not found
        push    bx
        mov     cx,1            ;read one byte
        mov     ax,cs
        mov     ds,ax           ;ds=code segment at interrupt time
        mov     dx,offset BUFFER
        mov     ah,3fh          ;read from file, handle=bx, bytes=cx
        int     21h
        pop     bx              ;handle=bx
        push    ax
        mov     ah,03eh         ;close file
        int     21h
        pop     ax
        cmp     ax,0            ;read nothing?
        mov     ax,1
        jz      stop
        mov     ax,0            ;return ax=0 to signal no create file
stop:
        ret

openfile endp

createfile proc near                    ;create dir entry
         assume ds:nothing
        mov     ax,cs                   ;with current time stamp
        mov     ds,ax                   ;0 byte file (no space used)
        mov     cx,0                    ;file attributes
        mov     dx,offset FILEN         ;full path name to create
        mov     ah,03ch                 ;create file
        int     21h
        jc      createfileexit
        mov     bx,ax
        mov     ah,03eh                 ;close file
        int     21h
createfileexit:
        ret
createfile endp


strcopy proc near
;cx=count, ds:si=source, es:di=dest. Copy until cx==0 or [si]==0
;ah=last byte copied or 0 if none are copied.
         assume ds:nothing
        mov     ah,0
strcopyloop:
        cmp     cx,0
        jz      strcopyquit
        dec     cx
        mov     al,byte ptr ds:[si]
        mov     byte ptr es:[di],al
        cmp     al,0
        jz      strcopyquit
        inc     si
        inc     di
        mov     ah,al
        jmp     strcopyloop
strcopyquit:
        mov     byte ptr es:[di],0
        ret
strcopy endp

makefilename proc near
;ds:dx=filename input. Split off dir name, add FREQ.USE, put back
;uses cx,ax,es,si,di
;filespec. New path name kept in FILEN below.
; example: ds:dx="c:\fonts\dpi300\cmr10.pk".
;          FILEN="c:\fonts\dpi300\FREQ.USE\cmr10.pk"
;
        assume ds:nothing
        mov     si,dx   ;ds:si = original path name
        mov     cx,0
strlen:
        cmp     byte ptr ds:[si],0
        jz      strlenquit
        inc     cx
        inc     si
        jmp     strlen
strlenquit:
makefileloop:                           ;find first dir path
        cmp     cx,0                    ;delimiter from end of string
        jz      makefileloopexit        ;adjust cx to new length for
        dec     si                      ;path name only.
        mov     al,byte ptr ds:[si]
        inc     si
        cmp     al,'/'
        jz      makefileloopexit
        cmp     al,'\'
        jz      makefileloopexit
        cmp     al,':'
        jz      makefileloopexit
        dec     si
        dec     cx
        jmp     makefileloop
makefileloopexit:
        push    ds                      ;save segment and string pointer
        push    si                      ;for filename only (no path).
        mov     si,dx                   ;restore head of source string
        mov     di,offset FILEN         ;pointer to dest string is es:di
        mov     ax,cs
        mov     es,ax   ;es:di = new path name
        call    strcopy                 ;copy path name only
        cmp     ah,0                    ;do we add '\' to path name?
        jz      makefilenext
        cmp     ah,'\'                  ;check for ":/\" chars
        jz      makefilenext
        cmp     ah,'/'
        jz      makefilenext
        mov     byte ptr es:[di],'\'    ;have to add dir path delimiter
        inc     di                      ;point to next byte to copy
makefilenext:
        mov     ax,cs                   ;copy FREQ.USE onto path string
        mov     ds,ax                   ;source=ds:si
        mov     si,offset FREQUSE
        mov     cx,100                  ;use 0 terminator to stop copy
        call    strcopy
        pop     si                      ;now add on the file name itself
        pop     ds
        mov     cx,14                   ;copy at most 14 chars
        call    strcopy
        ret
makefilename endp

;**************************************************************************
;resident portion above, temporary portion below
;**************************************************************************

               even
FILEN   db      'Author: G.B.Gustafson, 30 November 1991',13,10
        db      'email: gustafso@math.utah.edu.Internet ',13,10
        db      'Usage: MKDIR .\FREQ.USE in each subdirectory.'
BUFFER  db      0,0,0
FREQUSE db      'FREQ.USE','\',0
fn      db      1
stktop  dw      0
        dw      64 dup (0)
stkbot  dw      0       ;stack grows downward from here
;**************************************************************************
;temporary strings
mesg    db     13,10,'File use frequency TSR successfully installed'
        db     13,10,'MKDIR .\FREQ.USE in each subdirectory where'
        db     13,10,'last access dates/times are to be maintained.'
        db     13,10,36
mesg1   db     13,10,'File use frequency TSR already installed',13,10,36
;
init    proc   near
        assume ds:cseg

        mov     ax,'fr'
        int     21h
        jc      success         ;tsr not loaded
        cmp     ax,'eq'
        jne     success
        jmp     failed


;print a success message
success:
         mov    dx,offset mesg  ;start of message to write
         mov    ah,09H
         int    21H             ;DOS print string

;initialize location of WATCH stack
newstk: mov     ax,offset stkbot
        mov     newsp,ax
        mov     newss,cs        ;stack seg is code seg

;get int 21H vector
        cli
        mov    ax,3521H         ;GetVector DOS function call
        int    21H
        mov    old21,bx         ;store first word of old21
        mov    old21[2],es      ;store second word

;install the new vectors
        mov    ax,2521H
        mov    dx,offset newint21
        int    21H
        sti

;terminate and stay resident
        mov    ax,offset stkbot
        add    ax,15
        mov    cl,4
        shr    ax,cl
        mov    dx,ax
        mov    ax,3100H        ;return success code
        int    21H

failed:
        mov    dx,offset mesg1 ;start of message to write
        mov    ah,09H
        int    21H             ;DOS print string

        mov     ax,0
        int     21h
lastcode:
init    endp

Cseg    ends
        end     ComEntry

;***********************************************************************
;my debugging tools follow. Used to get it right.
;
;printword proc near
;       assume ds:nothing
;;
;; print error number
;        mov     cx,ax
;
;; once
;        and     ax,15
;        add     ax,'0'
;        mov     bx,0
;        mov     ah,14
;        int     10h
;        mov     ax,cx
;        mov     cl,4
;        shr     ax,cl
;        mov     cx,ax
;;twice
;        and     ax,15
;        add     ax,'0'
;        mov     bx,0
;        mov     ah,14
;        int     10h
;        mov     ax,cx
;        mov     cl,4
;        shr     ax,cl
;        mov     cx,ax
;;threee
;        and     ax,15
;        add     ax,'0'
;        mov     bx,0
;        mov     ah,14
;        int     10h
;        mov     ax,cx
;        mov     cl,4
;        shr     ax,cl
;        mov     cx,ax
;;four
;        and     ax,15
;        add     ax,'0'
;        mov     bx,0
;        mov     ah,14
;        int     10h
;        mov     ax,cx
;        mov     cl,4
;        shr     ax,cl
;        mov     cx,ax
;
;        ret
;printword endp
;***********************************************************************

;***********************************************************************
;printfile proc near
;         assume ds:nothing
;        mov     ax,cs
;        mov     ds,ax
;        mov     dx,offset FILEN
;        mov     si,dx
;        mov     cx,0
;printloop:
;        cmp     byte ptr ds:[si],0
;        jz      printloopexit
;        inc     si
;        inc     cx
;        jmp     printloop
;printloopexit:
;        mov     bx,1
;        mov     ah,40h                 ;write to file
;        int     21h
;        ret
;printfile endp
;***********************************************************************
