/* detex: to strip TeX's and LaTeX's commands
* modified for Turbo C '91-'92: t.m.sanders@umich.edu
* to compile:   tcc detex.c */

char *documentation[] = {
" SYNTAX",
"        detex -[i] file1 [file2 .....]",
"     or detex -[i]  < file1 [file2 ....]",
"",
"See the manual page for more details.",
"",
"        -i flag:     ignores TeX's and LaTeX's \input and \include commands",
"",
};

/* Author: Kamal Al-Yahya, Stanford University,      	11/1/83 */
/* Modified: Kamal Al-Yahya				6/30/86 */

int	doclength = { sizeof documentation/sizeof documentation[0] };

#include        <stdio.h>
#include <io.h> /* modified for Turbo-C header files -- tms */

int xargc;
char **xargv;

main(argc,argv)
int argc; 
char *argv[];
{
FILE *temp;
register char *cptr;
int piped_in;
int iflag,i;

/* If no arguments, and not in a pipeline, self document */
piped_in = ioctl ((fileno (stdin)), 6); /* mofified for different ioctl-- tms */
if (argc == 1 && !piped_in)
	{
	for( i=0; i<doclength; i++)
		printf("%s\n",documentation[i]);
	exit (0);
    }

/* process option flags */
xargc = argc;
xargv = argv;
for (xargc--,xargv++; xargc; xargc--,xargv++)
	{
	cptr = *xargv; 
	if( *cptr=='-' )
		{
		while( *(++cptr))
			{
			switch( *cptr )
				{
				case 'i':
					iflag=1;
					break;
				default:
			     		fprintf(stderr,
					"unknown flag -%c\n",*cptr);
					break;
				}
			}
		}
	}

/* first process pipe input */
if(piped_in)
	detex(stdin,&iflag);

/* then process input line for arguments and assume they are input files */
xargc = argc;
xargv = argv;
for (xargc--,xargv++; xargc; xargc--,xargv++)
	{
	cptr = *xargv; 
	if( *cptr=='-' ) continue;		/* this is a flag */
	if((temp=fopen(cptr,"r")) != NULL)
		detex(temp,&iflag);
	else
		fprintf(stderr,"detex: Cannot open %s\n",cptr);
	}

}

#define MAXLEN 500
detex(fp,iflag)			/* stripping TEX commands */

FILE *fp;
int *iflag;
{
FILE *fpp;
int c,c1;
char w[MAXLEN];
int i,j;

while ((c = getc(fp)) != EOF)
	{
	c1=' ' ;		/* initialize c1 */
	switch (c)
	{
/* detect TeX commands (backslash) */
	case '\\':
		c1=c ;		/* c1 is needed to see if there is \$ */
		c=' ' ;		/* "erase" the backslash */
		putc(c,stdout);
		while ((c = getc(fp)) != EOF)
			{
			/* see if input is the word */
			if (c == 'i' && c1 == '\\')
				{
				c1=' ' ;		/* reinitialize c1 */
				i=0;
				w[i]=c;
				while ((c = getc(fp)) != ' ')
					{
					if(c=='\n' || c=='$' || c=='#' || c=='%'
					|| c=='{' || c=='(' || c==')') break;
					w[++i]=c;
					}
			if(w[1]=='n' && w[2]=='p' && w[3]=='u' && w[4]=='t'
			   || w[1]=='n' && w[2]=='c' && w[3]=='l' && w[4]=='u'
			   && w[5]=='d' && w[6]=='e')
					{
/* if the word is input, get the file name */
					i=0;
					while (( c = getc(fp)) != ' ')
						{
						if (c == '\n' || c == '}') break;
						w[i++]=c;
						}
					for (j=i; j < MAXLEN; j++)
						w[j]='\0';
/* if iflag is turned on, don't open files requested by \input) */
					if (*iflag != 1)
					{
					fpp=fopen(w, "r"); /* open the new file */
					if( fpp == NULL )
					     {
/* if file is not found, try file.tex  */
					     w[i]='.';		w[i+1]='t';
					     w[i+2]='e';	w[i+3]='x';
					     fpp=fopen(w, "r");
					     if( fpp == NULL )
						{
				     		fprintf(stderr,
						"detex: Cannot open %s\n",w);
					        break;
						}
					     }
					for (i=0; i < MAXLEN; i++)
						w[i]='\0';
					/* nested detex */
					detex(fpp,iflag);
					fclose(fpp);
					}
					}
				}
			if (c == '$')			goto dollar;
			if (c == '%')			goto comm;
			if (c == '{' || c == '#')	break;
			if (c == ' ' || c == '\n' || c == '(' || c == ')')
				{
				putc(c,stdout);
				break;
				}
			c1=' ' ;			/* reinitialize c1 */
			}
		break;
/* come here if the character is dollar sign */
dollar:
	case '$':
		c=' ' ;		/* "erase" the dollar sign */
		putc (c,stdout);
		if (c1 == '\\')		 break;		/* means \$ */
		c = getc(fp);
		if(c == '$')		goto dollar2;
		else			goto dollar1;
		break;

/* see if it is an in-line equation (delimeter is one dollar sign) */
dollar1:
		while((c = getc(fp)) != EOF)
			if(c == '$')	break;
		break;

/* see if it is a displayed equation (delimeter is two dollar signs) */
dollar2:
		while((c = getc(fp)) != EOF)
			{
			if(c == '$')
				{
				c = getc(fp);
				if (c != '$') fprintf(stderr,
			"detex: unmatched dollar signs, I will ignore that\n");
				break;
				}
			}
		break;

/* ignore commented text */
comm:
	case '%':
		if (c1 == '\\')		 break;		/* means \% */
		while((c = getc(fp)) != EOF)
			if (c == '\n')
				{
				putc(c,stdout);
				break;
				}
		break;
/* erase these character */
	case '{':
		c=' ';
	case '}':
		c=' ';
	case '_':
		c=' ';
	case '^':
		c=' ';
	case '&':
		c=' ';
	case '#':
		c=' ';
/* default is doing nothing: pass the character to the output */
	default:
		putc(c,stdout);
		break;
	}
	}
}

