$EVENT OFF
defint a-z

SUB SetRefresh
shared Rate
x=int(Rate/256)
out 67,116
out 65,Rate-x*256
out 65,x
end sub

SUB Timing
shared ET&
mtimer
for i=1 to 50
  x=i*2+2
  x$=str$(i)
next i
ET&=mtimer
end sub

SUB ShowRate(Rate)
print " (HH=";hex$(int(Rate/256));"  LL=";hex$(Rate-int(Rate/256)*256);")"
end sub

SUB ShowHead
cls
print "CalcQF  by Ken Hipple (CIS:74076,2331) and Conrad Smith (76701,107)"
print " V1.0      Mississippi Data Equipment Co."
print "           625C Lakeland East Drive"
print "           Jackson, MS 39208               (601) 932-6332"
print
print "This program calculates and sets the optimum memory refresh rate for your"
print "machine.  It will then create a short .COM file that you can run to quickly"
print "set the refresh rate.  The memory refresh concept is from an article by"
print "Brian Roemmele in the 7/88 issue of PC Magazine.  The .COM file produced"
print "is the same as the QFRESH.COM program from that article.  Please see that"
print "article for a thorough discussion of memory refresh rates."
print
print "NOTE: It is possible that your machine will 'hang' before the point"
print "      CalcQF considers optimum is reached.  This will not harm your"
print "      machine but you will have to re-boot."
print
end sub

call ShowHead
ComLine$=ucase$(command$)
if instr(ComLine$,"/S") then WriteFile
Tolerance!=.00001
IRate=16
DspLine=17
if instr(ComLine$,"/I") then
  ComLine$=ComLine$+"/C"
  IRate=0
  while IRate<1
    locate DspLine,1
    input "Enter the increment rate desired: ",IRate
  wend
end if
EstOrig=1
if instr(ComLine$,"/O") then
  EstOrig=0
  ComLine$=ComLine$+"/C"
end if
if instr(ComLine$,"/T") then
  ComLine$=ComLine$+"/C"
  Tolerance!=0
  while Tolerance!<=0
    locate DspLine+1,1
    input "Enter the tolerance desired: ",Tolerance!
  wend
end if
if instr(ComLine$,"/C")=0 then
  locate 24,1
  print "Press any key to continue";
  while inkey$=""
  wend
  cls
  print "Switches:
  print
  print "/C - Calculate the optimum memory refresh rate.  /I, /O and /T imply /C"
  print "/I - change the default Increment rate of 16.  In general, larger values"
  print "     will produce numerically higher optimum rates and smaller values"
  print "     will produce lower ones"
  print "/O - don't estimate the Original refresh rate.
  print "/T - set the Tolerance.  The default value is 0.00001. This determines what"
  print "     rate CalcQF considers optimum.  Larger values (i.e. 0.01) should produce"
  print "     numerically lower optimum rates and smaller values (i.e. 0.000001)"
  print "     should produce higher ones."
  print "/S - Skip the calculation phase and go straight to file creation."
  print
  print "Do not press any keys while this program is running as this can affect"
  print "the calculations.  Some TSRs and device drivers may also affect them."
  print "Because of this you may want (or need) to run CalcQF with nothing loaded"
  print "into memory.  The rate referred to as the original rate is the refresh"
  print "rate in effect when CalcQF was started.  The rate CalcQF says is the best"
  print "rate is really only an approximation but it should be close to the best rate"
  print "for any given application.  At the very least it will provide you a good"
  print "starting point for further experimenting."
  locate 24,1
  print "Press any key to continue";
  while inkey$=""
  wend
  end
end if
delay 2
locate DspLine,1
print spc(79)
print spc(79)
call Timing
call Timing
call Timing
OrigET&=ET&
Rate=5
OrigRate=0
if EstOrig=1 then
  while OrigRate=0
    locate DspLine,1
    print "Estimated original refresh rate=";Rate;
    call SetRefresh
    call Timing
    NewET&=ET&
    if (ET&-OrigET&)/OrigET&<Tolerance!/10 then
      OrigRate=Rate
    else
      x=int(Rate/25)
      if x<1 then x=1
      if x>IRate then x=IRate
      incr Rate,x
    end if
  wend
  call ShowRate(OrigRate)
end if
Rate=18
BestET&=9999999
OldET&=BestET&
call SetRefresh
call Timing
StartET&=ET&
ET&=0
Rate=32

TimeIt:
call SetRefresh
call Timing
locate DspLine+1,1
print "Testing refresh rate:";Rate
if BestET&>ET& then
  BestRate=Rate
  BestET&=ET&
end if
Rate=Rate+IRate
if (OldET&-ET&)/OldET&>Tolerance! then
  OldET&=ET&
  goto TimeIt
end if
Rate=BestRate
call SetRefresh
locate DspLine+1,1
print "Best refresh rate is:";BestRate;
call ShowRate(BestRate)
if EstOrig=1 then
  print using "###.#% speed improvement over the original rate."_
    ;(OrigET&-BestET&)/OrigET&*100
end if
print using "###.#% speed improvement over rate=18 (HH=0  LL=12)"_
  ;(StartET&-BestET&)/StartET&*100
WriteFile:
Answer$=""
while Answer$<>"Y" and Answer$<>"N"
  Answer$=""
  locate DspLine+4,1
  print "Do you want to create a .COM file? (Y/N) ";
  while Answer$=""
    Answer$=ucase$(inkey$)
  wend
wend
if Answer$="Y" then
  FileName$=""
  while FileName$=""
    locate DspLine+4,1
    print spc(79);
    locate DspLine+4,1
    input "Enter the desired file name with no extension: (default=QFRESH) "_
      ,FileName$
    if len(FileName$)=0 then FileName$="QFRESH"
    if len(FileName$)>8 then FileName$=""
  wend
  Rate=-1
  while Rate<0 or Rate>65535
    locate DspLine+5,1
    input ;"Refresh rate to use: (0 or ENTER to use calculated rate) ",Rate
  wend
  if Rate>0 then BestRate=Rate
  open FileName$+".COM" as #1 len=1
  field #1,1 as CharOut$
  for i=1 to 14
    read x
    if x=1000 then x=BestRate-int(BestRate/256)*256
    if x=2000 then x=int(BestRate/256)
    lset CharOut$=chr$(x)
    put 1
  next i
  close
end if
data &HB0,&H74,&HE6,&H43,&HB0,1000,&HE6,&H41,&HB0,2000,&HE6,&H41,&HCD,&H20