            .386p


STRT_TIM    MACRO
            MOV     AL, 0B4h             ; Clock 2 als
            OUT     43h, AL              ; Rate Generator programmieren
            XOR     AL, AL               ; Null laden
            OUT     42h, AL              ; Clock 2
            OUT     42h, AL              ; nullsetzen
            ENDM

STOP_TIM    MACRO
            MOV     AL, 80h              ; Timer 2
            OUT     43h, AL              ; sofort latchen
            IN      AL, 42h              ; LSB auslesen
            MOV     BL, AL               ; LSB retten
            IN      AL, 42h              ; MSB auslesen
            MOV     BH, AL               ; MSB retten
            NEG     BX                   ; negieren fr Timercounts
            ENDM


CODE        SEGMENT BYTE USE16 PUBLIC BYTE 'CODE'
            ASSUME  CS: CODE

            PUBLIC  TestCache, TestCach286


TEST64K_D   PROC    NEAR
            MOV     ES, AX
            MOV     DS, AX
            XOR     BX, BX
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, DX
            REP     MOVSD
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, DX
            STRT_TIM
            REP     MOVSD
            STOP_TIM
            RET
TEST64K_D   ENDP


TEST64K_W   PROC    NEAR
            MOV     ES, AX
            MOV     DS, AX
            XOR     BX, BX
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, DX
            REP     MOVSW
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, DX
            STRT_TIM
            REP     MOVSW
            STOP_TIM
            RET
TEST64K_W   ENDP


TEST128K_D  PROC    NEAR
            MOV     DX, AX
            MOV     ES, AX
            MOV     DS, AX
            XOR     BX, BX
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 1000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     ES, DX
            MOV     DS, DX
            MOV     CX, 16384
            STRT_TIM
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 1000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            STOP_TIM
            RET
TEST128K_D  ENDP


TEST256K_D  PROC    NEAR
            MOV     DX, AX
            MOV     ES, AX
            MOV     DS, AX
            XOR     BX, BX
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 1000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 2000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 3000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     ES, DX
            MOV     DS, DX
            MOV     CX, 16384
            STRT_TIM
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 1000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 2000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 3000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            STOP_TIM
            RET
TEST256K_D  ENDP


TEST512K_D  PROC    NEAR
            MOV     DX, AX
            MOV     ES, AX
            MOV     DS, AX
            XOR     BX, BX
            MOV     SI, BX
            MOV     DI, BX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 1000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 2000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 3000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 4000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 5000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 6000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 7000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     ES, DX
            MOV     DS, DX
            MOV     CX, 16384
            STRT_TIM
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 1000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 2000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 3000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 4000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 5000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 6000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            MOV     AX, DX
            ADD     AX, 7000h
            MOV     ES, AX
            MOV     DS, AX
            MOV     CX, 16384
            REP     MOVSD
            STOP_TIM
            RET
TEST512K_D  ENDP

TestCache   PROC    FAR
            PUSHF
            PUSH    DS
            CLI
            CLD
            IN      AL, 61h              ; Port B - System Control
            AND     AL, 11111101b        ; Lautsprecher-Bit ausschalten
            OR      AL, 1                ; Bit fr Clock 2 anschalten
            OUT     61h, AL              ; und auf Port zurckschreiben
            MOV     AX, 1000h
            MOV     DX, 256
            CALL    TEST64K_D
            MOV     CS:[Time1K], BX
            MOV     AX, 1000h
            MOV     DX, 512
            CALL    TEST64K_D
            MOV     CS:[Time2K], BX
            MOV     AX, 1000h
            MOV     DX, 1024
            CALL    TEST64K_D
            MOV     CS:[Time4K], BX
            MOV     AX, 1000h
            MOV     DX, 2048
            CALL    TEST64K_D
            MOV     CS:[Time8K], BX
            MOV     AX, 1000h
            MOV     DX, 4096
            CALL    TEST64K_D
            MOV     CS:[Time16K], BX
            MOV     AX, 1000h
            MOV     DX, 8192
            CALL    TEST64K_D
            MOV     CS:[Time32K], BX
            MOV     AX, 1000h
            MOV     DX, 16384
            CALL    TEST64K_D
            MOV     CS:[Time64K], BX
            MOV     AX, 1000h
            CALL    TEST128K_D
            MOV     CS:[Time128K], BX
            MOV     AX, 1000h
            CALL    TEST256K_D
            MOV     CS:[Time256K], BX
            MOV     AX, 1000h
            CALL    TEST512K_D
            MOV     CS:[Time512K], BX
            MOV     DX, CS
            MOV     AX, OFFSET [Time1K]
            POP     DS
            POPF
            RET


TestCach286 PROC    FAR
            PUSHF
            PUSH    DS
            CLI
            CLD
            MOV     AX, 1000h
            IN      AL, 61h              ; Port B - System Control
            AND     AL, 11111101b        ; Lautsprecher-Bit ausschalten
            OR      AL, 1                ; Bit fr Clock 2 anschalten
            OUT     61h, AL              ; und auf Port zurckschreiben
            MOV     DX, 512
            CALL    TEST64K_W
            MOV     CS:[Time1K], BX
            MOV     AX, 1000h
            MOV     DX, 1024
            CALL    TEST64K_W
            MOV     CS:[Time2K], BX
            MOV     AX, 1000h
            MOV     DX, 2048
            CALL    TEST64K_W
            MOV     CS:[Time4K], BX
            MOV     AX, 1000h
            MOV     DX, 4096
            CALL    TEST64K_W
            MOV     CS:[Time8K], BX
            MOV     AX, 1000h
            MOV     DX, 8192
            CALL    TEST64K_W
            MOV     CS:[Time16K], BX
            MOV     AX, 1000h
            MOV     DX, 16384
            CALL    TEST64K_W
            MOV     CS:[Time32K], BX
            MOV     AX, 1000h
            MOV     DX, 32768
            CALL    TEST64K_W
            MOV     CS:[Time64K], BX
            MOV     DX, CS
            MOV     AX, OFFSET [Time1K]
            POP     DS
            POPF
            RET
TestCach286 ENDP

Time1K      DW      ?
Time2K      DW      ?
Time4K      DW      ?
Time8K      DW      ?
Time16K     DW      ?
Time32K     DW      ?
Time64K     DW      ?
Time128K    DW      ?
Time256K    DW      ?
Time512K    DW      ?

TestCache   ENDP

CODE        ENDS

            END


