;--- zansi.asm ----------------------------------------------------------
; Definitions for Zephyr ANSI terminal driver.
;    Copyright (C) 1986-1987, Thomas Hanlin III, Alexandria VA.
;    Based on original code for NANSI by Daniel Kegel, Pasadena CA.

is_8088		=	-1	; no fancy instructions if true
avatar		=	-1	; support AVATAR is true
wrap_left	=	-1	; support wrap left margin if true
direct_scroll	=	0	; direct access scroll if true
two_handlers	=	-1	; seperate KEYB driver included
fullscreen	=	-1	; full screen input if true
slow		=	0	; buffer cursor set for fast machines
xlate		=	-1	; allow keyboard translation

keybuf	struc
len	dw	?
adr	dw	?
keybuf	ends

	if	not is_8088
		.286c
	endif

;--- push_all, pop_all ------------------------------------------------
; Save/restore all user registers.
push_all	macro
	if	is_8088
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	else
	pusha
	endif
	push	ds
	push	es
	endm

pop_all	macro
	pop	es
	pop	ds
	if	is_8088
	pop	di
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	else
	popa
	endif
	endm

;--- hold ---------------------------------------------------------
; wait for the system to catch up on faster machines
hold	macro
	if	slow
	jmp	short $+2
	endif
	endm
;--- ABS40 ----------------------------------------------------------
; template for BIOS data area
ABS40	segment at 40h
	org	1ah
buffer_head	dw	?	; Used in 'flush input buffer' dos call.
buffer_tail	dw	?

	org	49h
crt_mode	db	?
crt_cols	dw	?
crt_len 	dw	?
crt_start	dw	?
cursor_posn	dw	8 dup (?)
cursor_mode	dw	?
active_page	db	?
addr_6845	dw	?
	org	6ch
timer_low	dw	?	; low word of time-of-day counter (18.2 hz)

	org	84h
crt_rows	db	?
ABS40	ends

;---- end of zavt_d.asm ----
